// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/samples/dout/main.h $
// $Rev: 53461 $
// $Date: 2023-07-26 15:41:42 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "24dsi20c500k_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	index;			// device index
	s32	minute_limit;	// for continuous testing
	int	qty;			// Number of devices detected.
	s32	ms_wait;		// Wait this long after each output.
	s32	pause;
	s32	repeat;
	s32	share;
	s32	test_limit;		// for continuous testing

	int	fd;				// File descriptor for device to access.

	// Device Settings

} args_t;



// prototypes *****************************************************************

int	perform_tests(const args_t* args);



#endif
