// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/samples/billion/perform.c $
// $Rev: 53459 $
// $Date: 2023-07-26 15:41:09 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_1B		(1000L * 1000L * 1000L)
#define	_1M		(1024L * 1024L)



// variables ******************************************************************

static	u32	_buffer[_1M];



//*****************************************************************************
static int _read_data(const args_t* args)
{
	int		errs	= 0;
	long	get;
	long	got;
	long	samples	= 0;

	gsc_label("Reading");

	for (;;)
	{
		get	= _1B - samples;

		if (get > (sizeof(_buffer) / 4))
			get	= sizeof(_buffer) / 4;

		got	= dsi20c500k_read(args->fd, _buffer, get);

		if (got < 0)
		{
			errs	= 1;
			printf(	"FAIL <---  (read error, errno %d)\n", errno);
			break;
		}

		if (got != get)
		{
			errs	= 1;
			printf(	"FAIL <---  (total %ld, requested %ld samples, got %ld samples)\n",
					(long) samples,
					(long) get,
					(long) got);
			break;
		}

		samples	+= got;

		if (samples >= _1B)
			break;
	}

	if (errs == 0)
		printf("PASS  (read %ld samples)\n", samples);

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;

	errs	+= dsi20c500k_config_ai(args->fd, -1, 1, -1, 100000);
	errs	+= _read_data(args);

	return(errs);
}


