// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/include/24dsi20c500k_utils.h $
// $Rev: 53473 $
// $Date: 2023-07-26 15:50:18 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Utilities: header file

#ifndef	__24DSI20C500K_UTILS_H__
#define	__24DSI20C500K_UTILS_H__

#include "24dsi20c500k_api.h"
#include "gsc_utils.h"
#include "gsc_utils_pci.h"



// prototypes *****************************************************************

// API utility services

int	dsi20c500k_close_util			(int fd, int index, int verbose);
int dsi20c500k_init_util			(int verbose);
int dsi20c500k_ioctl_util			(int fd, int index, int verbose, int request, void* arg);
int	dsi20c500k_open_util			(int device, int share, int index, int verbose, int* fd);
int	dsi20c500k_read_util			(int fd, int index, int verbose, void* dst, size_t bytes, size_t* got);

// IOCTL utility services

int	dsi20c500k_ai_buf_clear			(int fd, int index, int verbose, int at_boundary);				// DSI20C500K_IOCTL_AI_BUF_CLEAR
int	dsi20c500k_ai_buf_enable		(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_AI_BUF_ENABLE
int	dsi20c500k_ai_buf_fill_lvl		(int fd, int index, int verbose, s32* get);						// DSI20C500K_IOCTL_AI_BUF_FILL_LVL
int	dsi20c500k_ai_buf_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_AI_BUF_OVERFLOW
int	dsi20c500k_ai_buf_thr_sts		(int fd, int index, int verbose, s32* get);						// DSI20C500K_IOCTL_AI_BUF_THR_STS
int	dsi20c500k_ai_buf_thresh		(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_AI_BUF_THRESH
int	dsi20c500k_ai_buf_underflow		(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_AI_BUF_UNDERFLOW
int	dsi20c500k_ai_channel_tag		(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_AI_CHANNEL_TAG
int	dsi20c500k_ai_mode				(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_AI_MODE
int	dsi20c500k_autocal				(int fd, int index, int verbose);								// DSI20C500K_IOCTL_AUTOCAL
int	dsi20c500k_autocal_status		(int fd, int index, int verbose, s32* get);						// DSI20C500K_IOCTL_AUTOCAL_STATUS
int	dsi20c500k_burst				(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_BURST
int	dsi20c500k_burst_rate_div		(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_BURST_RATE_DIV
int	dsi20c500k_burst_size			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_BURST_SIZE
int	dsi20c500k_burst_timer			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_BURST_TIMER
int	dsi20c500k_burst_trigger		(int fd, int index, int verbose);								// DSI20C500K_IOCTL_BURST_TRIGGER
int	dsi20c500k_ch_grp_0_src			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_CH_GRP_0_SRC
int	dsi20c500k_ch_grp_1_src			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_CH_GRP_1_SRC
int	dsi20c500k_channels_ready		(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_CHANNELS_READY
int	dsi20c500k_control_mode			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_CONTROL_MODE
int	dsi20c500k_data_format			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_DATA_FORMAT
int	dsi20c500k_data_width			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_DATA_WIDTH
int	dsi20c500k_dio_dir_out			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_DIO_DIR_OUT
int	dsi20c500k_dio_read				(int fd, int index, int verbose, s32* get);						// DSI20C500K_IOCTL_DIO_READ
int	dsi20c500k_dio_write			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_DIO_WRITE
int	dsi20c500k_ext_clk_src			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_EXT_CLK_SRC
int	dsi20c500k_initialize			(int fd, int index, int verbose);								// DSI20C500K_IOCTL_INITIALIZE
int	dsi20c500k_irq_sel				(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_IRQ_SEL
int	dsi20c500k_led					(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_LED
int	dsi20c500k_ndiv					(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_NDIV
int	dsi20c500k_nref					(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_NREF
int	dsi20c500k_nvco					(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_NVCO
int	dsi20c500k_osr					(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_OSR
int	dsi20c500k_query				(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_QUERY
int	dsi20c500k_reg_mod				(int fd, int index, int verbose, u32 reg, u32 value, u32 mask);	// DSI20C500K_IOCTL_REG_MOD
int	dsi20c500k_reg_read				(int fd, int index, int verbose, u32 reg, u32* value);			// DSI20C500K_IOCTL_REG_READ
int	dsi20c500k_reg_write			(int fd, int index, int verbose, u32 reg, u32 value);			// DSI20C500K_IOCTL_REG_WRITE
int	dsi20c500k_rx_io_abort			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_RX_IO_ABORT
int	dsi20c500k_rx_io_mode			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_RX_IO_MODE
int	dsi20c500k_rx_io_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_RX_IO_OVERFLOW
int	dsi20c500k_rx_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_RX_IO_TIMEOUT
int	dsi20c500k_rx_io_underflow		(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_RX_IO_UNDERFLOW
int	dsi20c500k_sw_sync				(int fd, int index, int verbose);								// DSI20C500K_IOCTL_SW_SYNC
int	dsi20c500k_sw_sync_mode			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_SW_SYNC_MODE
int	dsi20c500k_wait_cancel			(int fd, int index, int verbose, gsc_wait_t* wait);				// DSI20C500K_IOCTL_WAIT_CANCEL
int	dsi20c500k_wait_event			(int fd, int index, int verbose, gsc_wait_t* wait);				// DSI20C500K_IOCTL_WAIT_EVENT
int	dsi20c500k_wait_status			(int fd, int index, int verbose, gsc_wait_t* wait);				// DSI20C500K_IOCTL_WAIT_STATUS
int	dsi20c500k_xcvr_type			(int fd, int index, int verbose, s32 set, s32* get);			// DSI20C500K_IOCTL_XCVR_TYPE

// Auxiliary utility services

int	dsi20c500k_channel_group		(int fd, int index, int verbose, s32 channel, s32* group);
int	dsi20c500k_config_ai			(int fd, int index, int verbose, s32 fref, s32 fsamp);
int	dsi20c500k_fsamp_ai_compute		(int fd, int index, int verbose, s32 fref, s32 fsamp, s32* nvco, s32* nref, s32* ndiv, s32* osr, double* rate);
int	dsi20c500k_fsamp_ai_report		(int fd, int index, int verbose, int chan, s32* fsamp);
int	dsi20c500k_fsamp_ai_report_all	(int fd, int index, int verbose, s32* fsamp);
int	dsi20c500k_fsamp_ai_validate	(int fd, int index, int verbose, s32* fsamp);
int	dsi20c500k_id_device			(int fd, int index, int verbose);

int	dsi20c500k_count_boards			(int verbose, s32* get);
int	dsi20c500k_reg_list				(int fd, int detail);

const gsc_reg_def_t*				dsi20c500k_reg_get_def_id	(u32 reg);
const gsc_reg_def_t*				dsi20c500k_reg_get_def_index(int index);
const char*							dsi20c500k_reg_get_desc		(u32 reg);
const char*							dsi20c500k_reg_get_name		(u32 reg);

// Retained for backwards compatibility only:
int	dsi20c500k_auto_cal_sts			(int fd, int index, int verbose, s32* get);
int	dsi20c500k_auto_calibrate		(int fd, int index, int verbose);

#endif


