// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/driver/24dsi20c500k.h $
// $Rev: 53477 $
// $Date: 2023-07-26 16:02:44 -0500 (Wed, 26 Jul 2023) $

// 24DSI20C500K: Device Driver: header file

#ifndef	__24DSI20C500K_H__
#define	__24DSI20C500K_H__

#include "gsc_common.h"
#include "gsc_pci9656.h"



// macros *********************************************************************

#define	DSI20C500K_BASE_NAME				"24dsi20c500k"
#define	DSI20C500K_BASE_NAME_LC				DSI20C500K_BASE_NAME
#define	DSI20C500K_BASE_NAME_UC				"DSI20C500K"

// IOCTL command codes
#define	DSI20C500K_IOCTL_REG_READ			OS_IOCTL_RW( 0, 12, gsc_reg_t)
#define	DSI20C500K_IOCTL_REG_WRITE			OS_IOCTL_W ( 1, 12, gsc_reg_t)
#define	DSI20C500K_IOCTL_REG_MOD			OS_IOCTL_W ( 2, 12, gsc_reg_t)
#define	DSI20C500K_IOCTL_QUERY				OS_IOCTL_RW( 3,  4, s32)
#define	DSI20C500K_IOCTL_INITIALIZE			OS_IOCTL   ( 4)
#define	DSI20C500K_IOCTL_AUTOCAL		OS_IOCTL   ( 5)
#define	DSI20C500K_IOCTL_AUTOCAL_STATUS		OS_IOCTL_R ( 6,  4, s32)
#define	DSI20C500K_IOCTL_AI_BUF_CLEAR		OS_IOCTL   ( 7)
#define	DSI20C500K_IOCTL_AI_BUF_ENABLE		OS_IOCTL_RW( 8,  4, s32)
#define	DSI20C500K_IOCTL_AI_BUF_FILL_LVL	OS_IOCTL_R ( 9,  4, s32)
#define	DSI20C500K_IOCTL_AI_BUF_OVERFLOW	OS_IOCTL_RW(10,  4, s32)
#define	DSI20C500K_IOCTL_AI_BUF_THR_STS		OS_IOCTL_R (11,  4, s32)
#define	DSI20C500K_IOCTL_AI_BUF_THRESH		OS_IOCTL_RW(12,  4, s32)
#define	DSI20C500K_IOCTL_AI_BUF_UNDERFLOW	OS_IOCTL_RW(13,  4, s32)
#define	DSI20C500K_IOCTL_AI_CHANNEL_TAG		OS_IOCTL_RW(14,  4, s32)
#define	DSI20C500K_IOCTL_AI_MODE			OS_IOCTL_RW(15,  4, s32)
#define	DSI20C500K_IOCTL_BURST				OS_IOCTL_RW(16,  4, s32)
#define	DSI20C500K_IOCTL_BURST_RATE_DIV		OS_IOCTL_RW(17,  4, s32)
#define	DSI20C500K_IOCTL_BURST_SIZE			OS_IOCTL_RW(18,  4, s32)
#define	DSI20C500K_IOCTL_BURST_TIMER		OS_IOCTL_RW(19,  4, s32)
#define	DSI20C500K_IOCTL_BURST_TRIGGER		OS_IOCTL   (20)
#define	DSI20C500K_IOCTL_CH_GRP_0_SRC		OS_IOCTL_RW(21,  4, s32)
#define	DSI20C500K_IOCTL_CH_GRP_1_SRC		OS_IOCTL_RW(22,  4, s32)
#define	DSI20C500K_IOCTL_CHANNELS_READY		OS_IOCTL_RW(23,  4, s32)
#define	DSI20C500K_IOCTL_CONTROL_MODE		OS_IOCTL_RW(24,  4, s32)
#define	DSI20C500K_IOCTL_DATA_FORMAT		OS_IOCTL_RW(25,  4, s32)
#define	DSI20C500K_IOCTL_DATA_WIDTH			OS_IOCTL_RW(26,  4, s32)
#define	DSI20C500K_IOCTL_DIO_DIR_OUT		OS_IOCTL_RW(27,  4, s32)
#define	DSI20C500K_IOCTL_DIO_READ			OS_IOCTL_R (28,  4, s32)
#define	DSI20C500K_IOCTL_DIO_WRITE			OS_IOCTL_RW(29,  4, s32)
#define	DSI20C500K_IOCTL_EXT_CLK_SRC		OS_IOCTL_RW(30,  4, s32)
#define	DSI20C500K_IOCTL_IRQ_SEL			OS_IOCTL_RW(31,  4, s32)
#define	DSI20C500K_IOCTL_LED				OS_IOCTL_RW(32,  4, s32)
#define	DSI20C500K_IOCTL_NDIV				OS_IOCTL_RW(33,  4, s32)
#define	DSI20C500K_IOCTL_NREF				OS_IOCTL_RW(34,  4, s32)
#define	DSI20C500K_IOCTL_NVCO				OS_IOCTL_RW(35,  4, s32)
#define	DSI20C500K_IOCTL_OSR				OS_IOCTL_RW(36,  4, s32)
#define	DSI20C500K_IOCTL_RX_IO_ABORT		OS_IOCTL_R (37,  4, s32)
#define	DSI20C500K_IOCTL_RX_IO_MODE			OS_IOCTL_RW(38,  4, s32)
#define	DSI20C500K_IOCTL_RX_IO_OVERFLOW		OS_IOCTL_RW(39,  4, s32)
#define	DSI20C500K_IOCTL_RX_IO_TIMEOUT		OS_IOCTL_RW(40,  4, s32)
#define	DSI20C500K_IOCTL_RX_IO_UNDERFLOW	OS_IOCTL_RW(41,  4, s32)
#define	DSI20C500K_IOCTL_SW_SYNC			OS_IOCTL   (42)
#define	DSI20C500K_IOCTL_SW_SYNC_MODE		OS_IOCTL_RW(43,  4, s32)
#define	DSI20C500K_IOCTL_WAIT_EVENT			OS_IOCTL_RW(44, 28, gsc_wait_t)
#define	DSI20C500K_IOCTL_WAIT_CANCEL		OS_IOCTL_RW(45, 28, gsc_wait_t)
#define	DSI20C500K_IOCTL_WAIT_STATUS		OS_IOCTL_RW(46, 28, gsc_wait_t)
#define	DSI20C500K_IOCTL_XCVR_TYPE			OS_IOCTL_RW(47,  4, s32)

//*****************************************************************************
// DSI20C500K_IOCTL_REG_READ
// DSI20C500K_IOCTL_REG_WRITE
// DSI20C500K_IOCTL_REG_MOD
//
#define	DSI20C500K_REG_ENCODE(s,o)			GSC_REG_ENCODE(GSC_REG_TYPE_BAR2,(s),(o))
// Parameter:	gsc_reg_t*
#define	DSI20C500K_GSC_BCTLR				DSI20C500K_REG_ENCODE(4,0x00)// Board Control Register
#define	DSI20C500K_GSC_RCR					DSI20C500K_REG_ENCODE(4,0x04)// Rate Control Register
#define	DSI20C500K_GSC_DIOPR				DSI20C500K_REG_ENCODE(4,0x08)// Digital I/O Port Register
#define	DSI20C500K_GSC_CSAR					DSI20C500K_REG_ENCODE(4,0x0C)// Clock Source Assignment Register
#define	DSI20C500K_GSC_RDR					DSI20C500K_REG_ENCODE(4,0x10)// Rate Divisors Register
#define	DSI20C500K_GSC_BBSR					DSI20C500K_REG_ENCODE(4,0x1C)// Burst Block Size Register
#define	DSI20C500K_GSC_BUFCR				DSI20C500K_REG_ENCODE(4,0x20)// Buffer Control Register
#define	DSI20C500K_GSC_BCFGR				DSI20C500K_REG_ENCODE(4,0x24)// Board Configuration Register
#define	DSI20C500K_GSC_BUFSR				DSI20C500K_REG_ENCODE(4,0x28)// Buffer Size Register
#define	DSI20C500K_GSC_AVR					DSI20C500K_REG_ENCODE(4,0x2C)// Autocal Values Register
#define	DSI20C500K_GSC_IDBR					DSI20C500K_REG_ENCODE(4,0x30)// Input Data Buffer Register
#define	DSI20C500K_GSC_BTTR					DSI20C500K_REG_ENCODE(4,0x3C)// Burst Trigger Timer Register

//*****************************************************************************
// DSI20C500K_IOCTL_QUERY
//
//	Parameter:	s32
//		Pass in a value from the list below.
//		The value returned is the answer to the query.

typedef enum
{
	DSI20C500K_QUERY_AUTOCAL_MS,	// Max autocalibrate period in ms.
	DSI20C500K_QUERY_CHANNEL_MAX,	// Maximum number of channels supported.
	DSI20C500K_QUERY_CHANNEL_QTY,	// The number of A/D channels.
	DSI20C500K_QUERY_COUNT,			// Number of query options.
	DSI20C500K_QUERY_DEVICE_TYPE,	// Value from gsc_dev_type_t
	DSI20C500K_QUERY_FGEN_MAX,		// Rate Generator maximum output rate.
	DSI20C500K_QUERY_FGEN_MIN,		// Rate Generator minimum output rate.
	DSI20C500K_QUERY_FIFO_SIZE,		// FIFO depth in 32-bit samples
	DSI20C500K_QUERY_FILTER_FREQ,	// Image Filter Frequency
	DSI20C500K_QUERY_FREF_DEFAULT,	// The default Fref value for the device.
	DSI20C500K_QUERY_FSAMP_MAX,		// The maximum sample rate.
	DSI20C500K_QUERY_FSAMP_MIN,		// The minimum sample rate.
	DSI20C500K_QUERY_INIT_MS,		// Max initialize period in ms.
	DSI20C500K_QUERY_NDIV_MAX,		// Maximum rate divisor Ndiv value.
	DSI20C500K_QUERY_NDIV_MIN,		// Maximum rate divisor Ndiv value.
	DSI20C500K_QUERY_NREF_MAX,		// PLL: Maximum rate generator Nref value.
	DSI20C500K_QUERY_NREF_MIN,		// PLL: Maximum rate generator Nref value.
	DSI20C500K_QUERY_NVCO_MAX,		// PLL: Maximum rate generator Nvco value.
	DSI20C500K_QUERY_NVCO_MIN,		// PLL: Maximum rate generator Nvco value.
	DSI20C500K_QUERY_V_RANGE,		// 10/6/5/2.5

	DSI20C500K_QUERY_LAST			// This is always last. Don't query this.
} dsi20c500k_query_t;

#define	DSI20C500K_IOCTL_QUERY_ERROR		(-1)	// Invalid/unknown query.

// Retained for backwards compatibility only:
#define	DSI20C500K_QUERY_AUTO_CAL_MS	DSI20C500K_QUERY_AUTOCAL_MS

// DSI20C500K_QUERY_V_RANGE values returned
#define	DSI20C500K_QUERY_V_RANGE_10			10	// +- 10
#define	DSI20C500K_QUERY_V_RANGE_6			6	// +- 6
#define	DSI20C500K_QUERY_V_RANGE_5			5	// +- 5
#define	DSI20C500K_QUERY_V_RANGE_2_5		2	// +- 2.5

// DSI20C500K_QUERY_FILTER_FREQ values returned
// 0 = no filter
// 2000000 = 2MHz filter
// -1 = unknown option

//*****************************************************************************
// DSI20C500K_IOCTL_INITIALIZE				BCTLR D15
//
//	Parameter:	None

//*****************************************************************************
// DSI20C500K_IOCTL_AUTOCAL					BCTLR D7
//
//	Parameter:	None

// Retained for backwards compatibility only:
#define	DSI20C500K_IOCTL_AUTO_CALIBRATE		DSI20C500K_IOCTL_AUTOCAL

//*****************************************************************************
// DSI20C500K_IOCTL_AUTOCAL_STATUS			BCTLR D7, D12
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_AUTOCAL_STATUS_ACTIVE	0
#define	DSI20C500K_AUTOCAL_STATUS_FAIL		1
#define	DSI20C500K_AUTOCAL_STATUS_PASS		2

// Retained for backwards compatibility only:
#define	DSI20C500K_IOCTL_AUTO_CAL_STS		DSI20C500K_IOCTL_AUTOCAL_STATUS
#define	DSI20C500K_AUTO_CAL_STS_ACTIVE		DSI20C500K_AUTOCAL_STATUS_ACTIVE
#define	DSI20C500K_AUTO_CAL_STS_FAIL		DSI20C500K_AUTOCAL_STATUS_FAIL
#define	DSI20C500K_AUTO_CAL_STS_PASS		DSI20C500K_AUTOCAL_STATUS_PASS

//*****************************************************************************
// DSI20C500K_IOCTL_AI_BUF_CLEAR			BUFCR D21
//
//	Parameter:	None

//*****************************************************************************
// DSI20C500K_IOCTL_AI_BUF_ENABLE			BUFCR D20
//
//	Parameter:	s32
//		Pass in any valid option below, or -1 to read the current setting.

#define	DSI20C500K_AI_BUF_ENABLE_NO			0
#define	DSI20C500K_AI_BUF_ENABLE_YES		1

//*****************************************************************************
// DSI20C500K_IOCTL_AI_BUF_FILL_LVL			BUFSR D0-D19
//
//	Parameter:	s32
//		Values returned are from 0 to 0x80000 (256K).

//*****************************************************************************
// DSI20C500K_IOCTL_AI_BUF_OVERFLOW			BUFCR D25
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_AI_BUF_OVERFLOW_CLEAR	0
#define	DSI20C500K_AI_BUF_OVERFLOW_TEST		(-1)

// The following are the set of returned values.
#define	DSI20C500K_AI_BUF_OVERFLOW_NO		0
#define	DSI20C500K_AI_BUF_OVERFLOW_YES		1

//*****************************************************************************
// DSI20C500K_IOCTL_AI_BUF_THR_STS			BCTLR D14
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_AI_BUF_THR_STS_IDLE		0
#define	DSI20C500K_AI_BUF_THR_STS_ACTIVE	1

//*****************************************************************************
// DSI20C500K_IOCTL_AI_BUF_THRESH			BUFCR D0-D19
//
//	Parameter:	s32
//		Pass in any valid from 0 to 0x80000, or -1 to read the current setting.

//*****************************************************************************
// DSI20C500K_IOCTL_AI_BUF_UNDERFLOW		BUFCR D26
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_AI_BUF_UNDERFLOW_CLEAR	0
#define	DSI20C500K_AI_BUF_UNDERFLOW_TEST	(-1)

// The following are the set of returned values.
#define	DSI20C500K_AI_BUF_UNDERFLOW_NO		0
#define	DSI20C500K_AI_BUF_UNDERFLOW_YES		1

//*****************************************************************************
// DSI20C500K_IOCTL_AI_CHANNEL_TAG			BUFCR D24
//
//	Parameter:	s32
//		Pass in any valid option below, or -1 to read the current setting.

#define	DSI20C500K_AI_CHANNEL_TAG_ENABLE	0
#define	DSI20C500K_AI_CHANNEL_TAG_DISABLE	1

//*****************************************************************************
// DSI20C500K_IOCTL_AI_MODE					BCTLR D0-D1
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_AI_MODE_DIFF				0	// Differential
#define	DSI20C500K_AI_MODE_ZERO				2	// Zero test
#define	DSI20C500K_AI_MODE_VREF				3	// Vref test

//*****************************************************************************
// DSI20C500K_IOCTL_BURST					BCTLR D21
//
//	Parameter:	s32
//		Pass in any valid option below, or -1 to read the current setting.

#define	DSI20C500K_BURST_DISABLE			0
#define	DSI20C500K_BURST_ENABLE				1

//*****************************************************************************
// DSI20C500K_IOCTL_BURST_RATE_DIV			BTTR D0-D23
//
//	Parameter:	s32
//		Pass in any valid from 0 to 0xFFFFFF, or -1 to read the current setting.

//*****************************************************************************
// DSI20C500K_IOCTL_BURST_SIZE				BBSR D0-D23
//
//	Parameter:	s32
//		Pass in any valid from 0 to 0xFFFFFF, or -1 to read the current setting.

//*****************************************************************************
// DSI20C500K_IOCTL_BURST_TIMER				BCTLR D16
//
//	Parameter:	s32
//		Pass in any valid option below, or -1 to read the current setting.

#define	DSI20C500K_BURST_TIMER_DISABLE		0
#define	DSI20C500K_BURST_TIMER_ENABLE		1

//*****************************************************************************
// DSI20C500K_IOCTL_BURST_TRIGGER			BCTLR D22
//
//	Parameter:	None

//*****************************************************************************
// DSI20C500K_IOCTL_CH_GRP_0_SRC			CSAR D0-D3
// DSI20C500K_IOCTL_CH_GRP_1_SRC			CSAR D4-D7
//
//	Parameter:	s32
//		Pass in any valid option below, or -1 to read the current setting.

#define	DSI20C500K_CH_GRP_SRC_RATE_GEN		0
#define	DSI20C500K_CH_GRP_SRC_EXTERN		4
#define	DSI20C500K_CH_GRP_SRC_DIR_EXTERN	5
#define	DSI20C500K_CH_GRP_SRC_DISABLE		6

//*****************************************************************************
// DSI20C500K_IOCTL_CHANNELS_READY			BCTLR D13
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.
#define	DSI20C500K_CHANNELS_READY_WAIT		0
#define	DSI20C500K_CHANNELS_READY_TEST		(-1)

// These are the values returned.
#define	DSI20C500K_CHANNELS_READY_NO		0
#define	DSI20C500K_CHANNELS_READY_YES		1

//*****************************************************************************
// DSI20C500K_IOCTL_CONTROL_MODE			BCTLR D5
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_CONTROL_MODE_TARGET		0
#define	DSI20C500K_CONTROL_MODE_INITIATOR	1

//*****************************************************************************
// DSI20C500K_IOCTL_DATA_FORMAT				BCTLR D4
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_DATA_FORMAT_2S_COMP		0	// Twos Compliment
#define	DSI20C500K_DATA_FORMAT_OFF_BIN		1	// Offset Binary

//*****************************************************************************
// DSI20C500K_IOCTL_DATA_WIDTH				BUFCR D21-D22
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_DATA_WIDTH_16			0
#define	DSI20C500K_DATA_WIDTH_18			1
#define	DSI20C500K_DATA_WIDTH_20			2
#define	DSI20C500K_DATA_WIDTH_24			3

//*****************************************************************************
// DSI20C500K_IOCTL_DIO_DIR_OUT				DIOPR D7, D15
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_DIO_DIR_OUT_NONE			0
#define	DSI20C500K_DIO_DIR_OUT_0_3			1
#define	DSI20C500K_DIO_DIR_OUT_4_7			2
#define	DSI20C500K_DIO_DIR_OUT_0_7			3

//*****************************************************************************
// DSI20C500K_IOCTL_DIO_READ				DIOPR D0-D3, D8-D11
//
//	Parameter:	s32
//		Values returned are from 0 to 0xFF.

//*****************************************************************************
// DSI20C500K_IOCTL_DIO_WRITE				DIOPR D0-D3, D8-D11
//
//	Parameter:	s32
//		Pass in any valid from 0 to 0xFF, or -1 to read the current setting.

//*****************************************************************************
// DSI20C500K_IOCTL_EXT_CLK_SRC				BCTLR D18
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_EXT_CLK_SRC_GRP_0		0
#define	DSI20C500K_EXT_CLK_SRC_GEN			1

//*****************************************************************************
// DSI20C500K_IOCTL_IRQ_SEL					BCTLR D8-D10
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_IRQ_INIT_DONE			0
#define	DSI20C500K_IRQ_AUTOCAL_DONE			1
#define	DSI20C500K_IRQ_CHAN_READY			2
#define	DSI20C500K_IRQ_AI_BUF_THR_L2H		3
#define	DSI20C500K_IRQ_AI_BUF_THR_H2L		4
#define	DSI20C500K_IRQ_AI_BURST_DONE		5

// Retained for backwards compatibility only:
#define	DSI20C500K_IRQ_AUTO_CAL_DONE		DSI20C500K_IRQ_AUTOCAL_DONE

//*****************************************************************************
// DSI20C500K_IOCTL_LED						BCTLR D19
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_LED_OFF					0
#define	DSI20C500K_LED_ON					1

//*****************************************************************************
// DSI20C500K_IOCTL_NDIV					RDR D0-D8
//
//	Parameter:	s32
//		Pass in any value from 1 to 3, or -1 to read the current setting.

//*****************************************************************************
// DSI20C500K_IOCTL_NREF					RCR D12-D23
//	Parameter:	s32
//		Pass in any value from 25 to 300, or -1 to read the current setting.

//*****************************************************************************
// DSI20C500K_IOCTL_NVCO					RCR D0-D11
//
//	Parameter:	s32
//		Pass in any value from 25 tp 300, or -1 to read the current setting.

//*****************************************************************************
// DSI20C500K_IOCTL_OSR						BCTLR D2-D3
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_OSR_256					0
#define	DSI20C500K_OSR_128					1
#define	DSI20C500K_OSR_64					2
#define	DSI20C500K_OSR_32					3

//*****************************************************************************
// DSI20C500K_IOCTL_RX_IO_ABORT
//
//	Parameter:	s32*
//		The returned value is one of the below options.

#define	DSI20C500K_IO_ABORT_NO				0
#define	DSI20C500K_IO_ABORT_YES				1

//*****************************************************************************
// DSI20C500K_IOCTL_RX_IO_MODE
//
//	Parameter:	s32
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.

#define	DSI20C500K_IO_MODE_DEFAULT			GSC_IO_MODE_PIO
// GSC_IO_MODE_PIO
// GSC_IO_MODE_BMDMA
// GSC_IO_MODE_DMDMA

//*****************************************************************************
// DSI20C500K_IOCTL_RX_IO_OVERFLOW
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_IO_OVERFLOW_DEFAULT		DSI20C500K_IO_OVERFLOW_CHECK
#define	DSI20C500K_IO_OVERFLOW_IGNORE		0
#define	DSI20C500K_IO_OVERFLOW_CHECK		1

//*****************************************************************************
// DSI20C500K_IOCTL_RX_IO_TIMEOUT			(in seconds)
//
//	Parameter:	s32
//		Pass in any value from the minimim to the maximim, the infinite option,
//		or -1 to read the current setting. The value -1 is returned if the
//		feature is not supported, but this should never happen.

#define	DSI20C500K_IO_TIMEOUT_DEFAULT		10
#define	DSI20C500K_IO_TIMEOUT_NO_SLEEP		0		// Don't sleep to wait for data.
#define	DSI20C500K_IO_TIMEOUT_MIN			0
#define	DSI20C500K_IO_TIMEOUT_MAX			GSC_IO_TIMEOUT_MAX
#define	DSI20C500K_IO_TIMEOUT_INFINITE		GSC_IO_TIMEOUT_INFINITE

//*****************************************************************************
// DSI20C500K_IOCTL_RX_IO_UNDERFLOW
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_IO_UNDERFLOW_DEFAULT		DSI20C500K_IO_UNDERFLOW_CHECK
#define	DSI20C500K_IO_UNDERFLOW_IGNORE		0
#define	DSI20C500K_IO_UNDERFLOW_CHECK		1

//*****************************************************************************
// DSI20C500K_IOCTL_SW_SYNC					BCTLR D6
//
//	Parameter:	None

//*****************************************************************************
// DSI20C500K_IOCTL_SW_SYNC_MODE			BCTLR D17
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_SW_SYNC_MODE_SYNC		0	// Perform a Sync operation
#define	DSI20C500K_SW_SYNC_MODE_CLR_BUF		1	// Clear the input buffer/

//*****************************************************************************
// DSI20C500K_IOCTL_WAIT_EVENT				all fields must be valid
// DSI20C500K_IOCTL_WAIT_CANCEL				fields need not be valid
// DSI20C500K_IOCTL_WAIT_STATUS				fields need not be valid
//
//	Parameter:	gsc_wait_t*
// gsc_wait_t.flags - see gsc_common.h
// gsc_wait_t.main - see gsc_common.h
// gsc_wait_t.gsc
#define	DSI20C500K_WAIT_GSC_INIT_DONE		0x0001
#define	DSI20C500K_WAIT_GSC_AUTOCAL_DONE	0x0002
#define	DSI20C500K_WAIT_GSC_CHAN_READY		0x0004
#define	DSI20C500K_WAIT_GSC_AI_BUF_THR_L2H	0x0008
#define	DSI20C500K_WAIT_GSC_AI_BUF_THR_H2L	0x0010
#define	DSI20C500K_WAIT_GSC_AI_BURST_DONE	0x0020
#define	DSI20C500K_WAIT_GSC_ALL				0x003F
// gsc_wait_t.alt flags
#define	DSI20C500K_WAIT_ALT_ALL				0x0000
// gsc_wait_t.io
#define	DSI20C500K_WAIT_IO_RX_ABORT			0x0001
#define	DSI20C500K_WAIT_IO_RX_DONE			0x0002
#define	DSI20C500K_WAIT_IO_RX_ERROR			0x0004
#define	DSI20C500K_WAIT_IO_RX_TIMEOUT		0x0008

#define	DSI20C500K_WAIT_IO_ALL				0x000F

// Retained for backwards compatibility only:
#define	DSI20C500K_WAIT_GSC_AUTO_CAL_DONE	DSI20C500K_WAIT_GSC_AUTOCAL_DONE

//*****************************************************************************
// DSI20C500K_IOCTL_XCVR_TYPE				BCTLR D20
//
//	Parameter:	s32
//		Pass in any of the below options, or -1 to read the current setting.

#define	DSI20C500K_XCVR_TYPE_LVDS			0
#define	DSI20C500K_XCVR_TYPE_TTL			1

#endif
