// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI20C500K/api/read.c $
// $Rev: 45862 $
// $Date: 2019-08-13 12:47:49 -0500 (Tue, 13 Aug 2019) $

// 24DSI20C500K: API Library: source file

#include "main.h"



//*****************************************************************************
// Return Values:
//	>=0	= success, the number of bytes transferred
//	<0  = failure, value is -errno or -GetLastError (Windows only)
int dsi20c500k_read(int fd, void* dst, size_t bytes)
{
	int	ret;

	if (bytes > GSC_IO_SIZE_QTY_MASK)
		bytes	= GSC_IO_SIZE_QTY_MASK & ~0x3;

	bytes	|= STREAM_ID_RX;
	ret		= gsc_api_read(fd, dst, bytes);
	return(ret);
}


