// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/utils/util_rx_io_timeout.c $
// $Rev: 52535 $
// $Date: 2023-03-02 14:55:56 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi12wi_rx_io_timeout
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI12WI_IOCTL_RX_IO_TIMEOUT service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi12wi_rx_io_timeout(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;

	if (verbose)
		gsc_label_index("Rx I/O Timeout", index);

	ret		= dsi12wi_ioctl(fd, DSI12WI_IOCTL_RX_IO_TIMEOUT, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
	{
		if (set == -1)
		{
			ptr	= "This service is not supported by this device.";
		}
		else if (set == DSI12WI_IO_TIMEOUT_INFINITE)
		{
			ptr	= "infinite/never timeout";
		}
		else
		{
			sprintf(buf, "%ld second%s", (long) set, (set == 1) ? "" : "s");
			ptr	= buf;
		}

		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);
	}

	if (get)
		get[0]	= set;

	return(errs);
}


