// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/utils/util_reg_write.c $
// $Rev: 52535 $
// $Date: 2023-03-02 14:55:56 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi12wi_reg_write
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI12WI_IOCTL_REG_WRITE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		reg		This is the register to access.
*
*		set		This is the value to apply.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi12wi_reg_write(int fd, int index, int verbose, u32 reg, u32 set)
{
	gsc_reg_t	arg;
	int			errs;
	int			ret;
	const char*	name;

	if (verbose)
		gsc_label_index("Register Write", index);

	arg.reg		= reg;
	arg.value	= set;
	arg.mask	= 0;	// unused here
	ret			= dsi12wi_ioctl(fd, DSI12WI_IOCTL_REG_WRITE, &arg);
	errs		= ret ? 1 : 0;

	if (verbose)
	{
		name	= dsi12wi_reg_get_name(reg);
		printf(	"%s  (val 0x%08lX, %s)\n",
				errs ? "FAIL <---" : "PASS",
				(unsigned long) arg.value,
				name ? name : "UNKNOWN");
	}

	return(errs);
}


