// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/utils/util_config_ai.c $
// $Rev: 52535 $
// $Date: 2023-03-02 14:55:56 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi12wi_config_ai
*
*	Purpose:
*
*		Configure the given device using common defaults.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*		fsamp	This is the desired Fsamp rate, of -1 to use the default.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int	dsi12wi_config_ai(int fd, int index, int verbose, s32 fsamp)
{
	int	errs	= 0;
	s32	mode;
	s32	ndiv;
	s32	nref;
	s32	nvco;

	if (verbose)
	{
		gsc_label_index("Input Configuration", index);
		gsc_label_level_inc();
		printf("\n");
	}

	errs	+= dsi12wi_initialize				(fd, index, verbose);
	errs	+= dsi12wi_rx_io_mode				(fd, index, verbose, GSC_IO_MODE_DMDMA,						NULL);
	errs	+= dsi12wi_rx_io_overflow			(fd, index, verbose, DSI12WI_IO_OVERFLOW_CHECK,				NULL);
	errs	+= dsi12wi_rx_io_timeout			(fd, index, verbose, 30,									NULL);
	errs	+= dsi12wi_rx_io_underflow			(fd, index, verbose, DSI12WI_IO_UNDERFLOW_CHECK,			NULL);
	errs	+= dsi12wi_ai_buf_thresh			(fd, index, verbose, 128L * 1024,							NULL);
	errs	+= dsi12wi_ai_channel_tag			(fd, index, verbose, DSI12WI_AI_CHANNEL_TAG_ENABLE,			NULL);
	errs	+= dsi12wi_data_format				(fd, index, verbose, DSI12WI_DATA_FORMAT_OFF_BIN,			NULL);
	errs	+= dsi12wi_data_width				(fd, index, verbose, DSI12WI_DATA_WIDTH_16,					NULL);
	errs	+= dsi12wi_irq_sel					(fd, index, verbose, DSI12WI_IRQ_INIT_DONE,					NULL);

	errs	+= dsi12wi_ai_mode					(fd, index, verbose, DSI12WI_AI_MODE_DIFF,					NULL);
	errs	+= dsi12wi_input_comp				(fd, index, verbose, DSI12WI_INPUT_COMP_OFF,				NULL);
	errs	+= dsi12wi_ch_grp_0_src				(fd, index, verbose, DSI12WI_CH_GRP_SRC_RATE_GEN,			NULL);
	errs	+= dsi12wi_ch_grp_1_src				(fd, index, verbose, DSI12WI_CH_GRP_SRC_RATE_GEN,			NULL);
	errs	+= dsi12wi_range					(fd, index, verbose, DSI12WI_RANGE_10V,						NULL);
	errs	+= dsi12wi_clock_control_mode		(fd, index, verbose, DSI12WI_CONTROL_MODE_INITIATOR,		NULL);
	errs	+= dsi12wi_excitation_current		(fd, index, verbose, DSI12WI_EXCITATION_CURRENT_OFF,		NULL);
	errs	+= dsi12wi_coupling_mode			(fd, index, verbose, DSI12WI_COUPLING_MODE_AC,				NULL);
	errs	+= dsi12wi_ext_clk_src				(fd, index, verbose, DSI12WI_EXT_CLK_SRC_GRP_0,				NULL);
	errs	+= dsi12wi_ext_sync_dir				(fd, index, verbose, DSI12WI_EXT_SYNC_DIR_OUT,				NULL);
	errs	+= dsi12wi_aux_clk_ctl_mode			(fd, index, verbose, DSI12WI_AUX_CLK_CTL_MODE_INACTIVE,		NULL);
	errs	+= dsi12wi_aux_sync_ctl_mode		(fd, index, verbose, DSI12WI_AUX_SYNC_CTL_MODE_INACTIVE,	NULL);
	errs	+= dsi12wi_burst_enable				(fd, index, verbose, DSI12WI_BURST_ENABLE_NO,				NULL);
	errs	+= dsi12wi_burst_rate_div			(fd, index, verbose, 1,										NULL);
	errs	+= dsi12wi_burst_size				(fd, index, verbose, 1,										NULL);
	errs	+= dsi12wi_burst_timer				(fd, index, verbose, DSI12WI_BURST_TIMER_DISABLE,			NULL);
	errs	+= dsi12wi_sw_sync_mode				(fd, index, verbose, DSI12WI_SW_SYNC_MODE_SYNC,				NULL);
	errs	+= dsi12wi_sync_control_mode		(fd, index, verbose, DSI12WI_CONTROL_MODE_INITIATOR,		NULL);
	errs	+= dsi12wi_fsamp_ai_compute			(fd, index, verbose, fsamp, &mode, &nvco, &nref, &ndiv,		NULL);
	errs	+= dsi12wi_adc_mode					(fd, index, verbose, mode,									NULL);
	errs	+= dsi12wi_nvco						(fd, index, verbose, nvco,									NULL);
	errs	+= dsi12wi_nref						(fd, index, verbose, nref,									NULL);
	errs	+= dsi12wi_ndiv						(fd, index, verbose, ndiv,									NULL);
	errs	+= dsi12wi_ai_buf_enable			(fd, index, verbose, DSI12WI_AI_BUF_ENABLE_YES,				NULL);
	errs	+= dsi12wi_fsamp_ai_report_all		(fd, index, verbose,										NULL);
	errs	+= dsi12wi_auto_cal					(fd, index, verbose);
	errs	+= dsi12wi_auto_cal_sts				(fd, index, verbose,										NULL);
	errs	+= dsi12wi_ai_buf_clear				(fd, index, verbose);
	errs	+= dsi12wi_ai_buf_overflow			(fd, index, verbose, DSI12WI_AI_BUF_OVERFLOW_CLEAR,			NULL);
	errs	+= dsi12wi_ai_buf_underflow			(fd, index, verbose, DSI12WI_AI_BUF_UNDERFLOW_CLEAR,		NULL);
	errs	+= dsi12wi_channels_ready			(fd, index, verbose, DSI12WI_CHANNELS_READY_TEST,			NULL);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


