// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/utils/util_channels_ready.c $
// $Rev: 46054 $
// $Date: 2019-08-13 15:30:52 -0500 (Tue, 13 Aug 2019) $

// 24DSI12WRCIEPE: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi12wi_channels_ready
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI12WI_IOCTL_CHANNELS_READY service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi12wi_channels_ready(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs	= 0;
	const char*	ptr;
	int			ret;

	if (verbose)
		gsc_label_index("Channels Ready", index);

	ret	= dsi12wi_ioctl(fd, DSI12WI_IOCTL_CHANNELS_READY, (void*) &set);

	if (ret)
	{
		if (errno == ETIMEDOUT)
		{
			set	= DSI12WI_CHANNELS_READY_NO;
		}
		else
		{
			errs++;
			printf("ERROR: dsi12wi_ioctl() failure, errno = %d\n", errno);
		}
	}

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case DSI12WI_CHANNELS_READY_NO:

			ptr	= "No, timed out";
			break;

		case DSI12WI_CHANNELS_READY_YES:

			ptr	= "Yes";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}



