// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/utils/util_burst_rate_div.c $
// $Rev: 52535 $
// $Date: 2023-03-02 14:55:56 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi12wi_burst_rate_div
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI12WI_IOCTL_BURST_RATE_DIV service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi12wi_burst_rate_div(int fd, int index, int verbose, s32 set, s32* get)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Burst Rate Divisor", index);

	ret		= dsi12wi_ioctl(fd, DSI12WI_IOCTL_BURST_RATE_DIV, &set);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s  (%ld)\n", errs ? "FAIL <---" : "PASS", (long) set);

	if (get)
		get[0]	= set;

	return(errs);
}


