// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/utils/util_auto_cal_sts.c $
// $Rev: 52535 $
// $Date: 2023-03-02 14:55:56 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi12wi_auto_cal_sts
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI12WI_IOCTL_AUTO_CAL_STS service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi12wi_auto_cal_sts(int fd, int index, int verbose, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;
	s32			set;

	if (verbose)
		gsc_label_index("Auto-Cal Status", index);

	ret		= dsi12wi_ioctl(fd, DSI12WI_IOCTL_AUTO_CAL_STS, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case DSI12WI_AUTO_CAL_STS_ACTIVE:

			ptr	= "Auto-Calibration is still active.";
			break;

		case DSI12WI_AUTO_CAL_STS_FAIL:

			ptr	= "Auto-Calibration failed.";
			break;

		case DSI12WI_AUTO_CAL_STS_PASS:

			ptr	= "Auto-Calibration passed.";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


