// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/utils/util_auto_cal.c $
// $Rev: 52535 $
// $Date: 2023-03-02 14:55:56 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi12wi_auto_cal
*
*	Purpose:
*
*		Provide a visual wrapper for the DSI12WI_IOCTL_AUTO_CAL service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int dsi12wi_auto_cal(int fd, int index, int verbose)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Auto-Calibrate", index);

	ret		= dsi12wi_ioctl(fd, DSI12WI_IOCTL_AUTO_CAL, NULL);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}


