// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/utils/read.c $
// $Rev: 52535 $
// $Date: 2023-03-02 14:55:56 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi12wi_read_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device read call.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		dst		The data read is placed here.
*
*		bytes	The volume of data to read.
*
*	Returned:
*
*		>= 0	The volume of data read.
*		< 0		The negative of the number of errors seen.
*
******************************************************************************/

int dsi12wi_read_util(int fd, int index, int verbose, void* dst, size_t bytes)
{
	int	ret;

	if (verbose)
		gsc_label_index("Reading", index);

	ret	= dsi12wi_read(fd, dst, bytes);

	if (verbose == 0)
	{
	}
	else if (ret >= 0)
	{
		printf("PASS  (%d Byte%s)\n", ret, (ret == 1) ? "" : "s");
	}
	else
	{
		printf(	"FAIL <---  (requested %ld Byte%s, ret = %ld)\n",
				(long) bytes,
				(bytes == 1) ? "" : "s",
				(long) ret);
	}

	return(ret);
}


