// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/utils/open.c $
// $Rev: 52535 $
// $Date: 2023-03-02 14:55:56 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	dsi12wi_open_util
*
*	Purpose:
*
*		Implement a visual wrapper around the device open call.
*
*	Arguments:
*
*		device	The zero based index of the device to access.
*
*		share	Open the device in shared access mode?
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		fd		The file descriptor is returned here.
*
*	Returned:
*
*		0		All went well. The fd value is valid.
*		> 0		The number of errors seen. The fd value is -1.
*
******************************************************************************/

int dsi12wi_open_util(int device, int share, int index, int verbose, int* fd)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Open", index);

	ret		= dsi12wi_open(device, share, fd);
	errs	= ret ? 1 : 0;

	if (verbose)
	{
		printf(	"%s  (%s)\n",
				errs ? "FAIL <---" : "PASS",
				share ? "Shared" : "Exclusive");
	}

	return(errs);
}


