// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/samples/stream/main.h $
// $Rev: 52542 $
// $Date: 2023-03-02 14:58:50 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "24dsi12wrciepe_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)						(sizeof((a)) / sizeof((a)[0]))

#define	RX_OPTION_ZERO_DATA					0
#define	RX_OPTION_READ_DEV					1

#define	TX_OPTION_BIT_BUCKET				0
#define	TX_OPTION_WRITE_FILE_BIN			1
#define	TX_OPTION_WRITE_FILE_TEXT			2

#define	_1M									(1L * 1024 * 1024)

#define	BUFFER_QTY							4
#define	BUFFER_SIZE							(_1M - (_1M % (24 * 4)))



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	force;			// Force operation even if errors occur.
	s32	fsamp;			// The desired sample rate.
	s32	index;			// device index
	s32	minute_limit;
	s32	stats;
	s32	test_limit;

	int	fd;

	// Device Settings

	s32	io_mode;
} args_t;

typedef struct
{
	const args_t*	args;			// Set by controlling thread for device access
	int				fd;				// Set by controlling thread for device access
	s32				option;			// Set by controlling thread to designate processing activity
	s32				rx_mb;			// Set by controlling thread to designate processing activity
	os_thread_t		thread;			// Set by controlling thread when thread is created
	s32				seconds;		// Set by controlling thread to designate processing activity
	int				start;			// set by controlling thread to request that we start processing
	int				stop;			// set by controlling thread to request that we stop processing

	int				done;			// set by new thread to report that it is done
	int				errs;			// Set by new thread to report any errors
	char			err_buf[128];	// Set by new thread to describe error condition.
	int				started;		// set by new thread to indicate it has started
	long long		total_bytes;	// Set by new thread for accounting purposes
	long			total_ms;		// Set by new thread for accounting purposes
} rx_data_t;

typedef struct
{
	const args_t*	args;			// Set by controlling thread for device access
	int				fd;				// Set by controlling thread for device access
	s32				chan_qty;		// Set by controlling thread for processing thread.
	int				option;			// Set by controlling thread to designate processing activity
	int				validate;		// Set by controlling thread to enable minor validation
	os_thread_t		thread;			// Set by controlling thread when thread is created
	int				start;			// set by controlling thread to request that we start processing
	int				stop;			// set by controlling thread to request that we stop processing
	FILE*			file;			// Set by controlling thread for data destination.
	char			name[64];		// Set by controlling thread for data destination.

	int				done;			// set by new thread to report that it is done
	int				errs;			// Set by new thread to report any errors
	char			err_buf[128];	// Set by new thread to describe error condition.
	int				started;		// set by new thread to indicate it has started
	long long		total_bytes;	// Set by new thread for accounting purposes
	long			total_ms;		// Set by new thread for accounting purposes
} tx_data_t;



// prototypes *****************************************************************

int		perform_tests(const args_t* args, rx_data_t* rx, tx_data_t* tx);

int		rx_start(rx_data_t* rx);
int		rx_stop(rx_data_t* rx);

int		tx_start(tx_data_t* tx);
int		tx_stop(tx_data_t* tx);
void	tx_validation_results(void);



#endif
