// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/samples/signals/perform.c $
// $Rev: 52541 $
// $Date: 2023-03-02 14:58:19 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	time_t	end;
	int		errs	= 0;
	s32		mode	= 0;
	s32		ndiv	= 0;
	time_t	now;
	s32		nref	= 0;
	s32		nvco	= 0;
	s32		fsamp	= 10000;

	errs	+= dsi12wi_initialize			(args->fd, -1, 1);

	// The output clock signal.
	gsc_label("Clock Output");
	printf("\n");
	gsc_label_level_inc();
	errs	+= dsi12wi_clock_control_mode	(args->fd, -1, 1, DSI12WI_CONTROL_MODE_INITIATOR, NULL);
	errs	+= dsi12wi_fsamp_ai_compute		(args->fd, -1, 1, fsamp, &mode, &nvco, &nref, &ndiv, NULL);
	errs	+= dsi12wi_adc_mode				(args->fd, -1, 1, mode, NULL);
	errs	+= dsi12wi_nvco					(args->fd, -1, 1, nvco, NULL);
	errs	+= dsi12wi_nref					(args->fd, -1, 1, nref, NULL);
	errs	+= dsi12wi_ndiv					(args->fd, -1, 1, ndiv, NULL);
	errs	+= dsi12wi_ext_clk_src			(args->fd, -1, 1, DSI12WI_EXT_CLK_SRC_GEN, NULL);
	gsc_label_level_dec();

	// The auxiliary output clock signal.
	gsc_label("Aux Clock Output");
	printf("\n");
	gsc_label_level_inc();
	errs	+= dsi12wi_aux_clk_ctl_mode		(args->fd, -1, 1, DSI12WI_AUX_CLK_CTL_MODE_OUTPUT, NULL);
	gsc_label_level_dec();

	// The output SYNC signal.
	gsc_label("SYNC Output");
	printf("\n");
	gsc_label_level_inc();
	errs	+= dsi12wi_sync_control_mode	(args->fd, -1, 1, DSI12WI_CONTROL_MODE_INITIATOR, NULL);
	errs	+= dsi12wi_ext_sync_dir			(args->fd, -1, 1, DSI12WI_EXT_SYNC_DIR_OUT, NULL);
	errs	+= dsi12wi_burst_size			(args->fd, -1, 1, 3, NULL);
	errs	+= dsi12wi_burst_rate_div		(args->fd, -1, 1, 245760, NULL);
	errs	+= dsi12wi_burst_timer			(args->fd, -1, 1, DSI12WI_BURST_TIMER_ENABLE, NULL);
	errs	+= dsi12wi_burst_enable			(args->fd, -1, 1, DSI12WI_BURST_ENABLE_YES, NULL);
	gsc_label_level_dec();

	// The auxiliary output SYNC signal.
	gsc_label("Aux SYNC Output");
	printf("\n");
	gsc_label_level_inc();
	errs	+= dsi12wi_aux_sync_ctl_mode	(args->fd, -1, 1, DSI12WI_AUX_SYNC_CTL_MODE_OUTPUT, NULL);
	gsc_label_level_dec();

	gsc_label("Waiting");
	printf("%d seconds ... ", args->seconds);
	fflush(stdout);
	end	= time(NULL) + args->seconds;

	for (; errs == 0;)
	{
		now	= time(NULL);

		if (now > end)
			break;

		gsc_time_sleep_ms(1);
	}

	printf("Done\n");
	gsc_label_level_dec();

	errs	+= dsi12wi_initialize(args->fd, -1, 1);
	return(errs);
}



