// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/samples/savedata/perform.c $
// $Rev: 52540 $
// $Date: 2023-03-02 14:58:02 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_1M		(1L * 1024L * 1024L)



// variables ******************************************************************

static	u32	_buffer[_1M];



//*****************************************************************************
static int _channels(const args_t* args, s32* chans)
{
	int	errs;

	gsc_label("Input Channels");
	errs	= dsi12wi_query(args->fd, -1, 0, DSI12WI_QUERY_CHANNEL_QTY, chans);

	if (errs == 0)
		printf("%ld Channels\n", (long) chans[0]);

	return(errs);
}



//*****************************************************************************
static int _read_data(const args_t* args)
{
	char	buf[80];
	int		errs	= 0;
	long	get		= sizeof(_buffer);
	int		got;
	int		index;

	for (index = 0; (errs == 0) && (index < args->repeat);)
	{
		index++;
		strcpy(buf, "Reading");

		if (args->repeat > 1)
		{
			strcat(buf, " #");
			gsc_label_long_comma_buf(index, buf + strlen(buf));
		}

		gsc_label(buf);

		got	= dsi12wi_read(args->fd, _buffer, get);

		if (got < 0)
		{
			errs++;
			printf("FAIL <---  (read error: %d)\n", got);
			break;
		}

		if (got != get)
		{
			errs	= 1;
			printf(	"FAIL <---  (got %ld bytes, requested %ld)\n",
					(long) got,
					(long) get);
			break;
		}

		errs	= 0;
		printf("PASS  (");
		gsc_label_long_comma(get / 4);
		printf(" samples)\n");
	}

	return(errs);
}



//*****************************************************************************
static int _save_eol(const char* name, FILE* file)
{
	int	errs	= 0;
	int	i;

	i	= fprintf(file, "\r\n");

	if (i != 2)
	{
		printf("FAIL <---  (fprintf() failure to %s)\n", name);
		errs	= 1;
	}

	return(errs);
}



//*****************************************************************************
static int _save_value(const args_t* args, const char* name, FILE* file, u32 value)
{
	char	buf[80];
	int		errs	= 0;
	int		i;
	int		len;

	if (args->tag_strip)
		value &= 0xFFFFFF;

	if (args->decimal)
		sprintf(buf, "%ld", (long) value);
	else
		sprintf(buf, "%08lX", (long) value);

	len	= (int) strlen(buf);
	i	= fprintf(file, "  %8s", buf);

	if (i != (len + 2))
	{
		printf("FAIL <---  (fprintf() failure to %s)\n", name);
		errs	= 1;
	}

	return(errs);
}



//*****************************************************************************
static int _validate_data(int chans, u32 last, long index, u32 data)
{
	int	chan_tag;
	int	errs		= 0;
	int	expect;
	int	last_tag;

	if (data & 0xF0000000)
	{
		errs	= 1;
		printf(" FAIL <---  (Upper bits are invalid: [%ld] = 0x%08lX)\n", index, (long) data);
	}

	chan_tag	= (data >> 24) & 0xF;

	if (chan_tag >= chans)
	{
		errs	= 1;
		printf(" FAIL <---  (Invalid Channel Tag: [%ld] = 0x%08lX)\n", index, (long) data);
	}

	if (last == 0xFFFFFFFF)
	{
		if (chan_tag != 0)
		{
			errs	= 1;
			printf(" FAIL <---  (First tag not zero: [%ld] = 0x%08lX)\n", index, (long) data);
		}
	}
	else
	{
		last_tag	= last >> 24;
		expect		= (last_tag + 1) % chans;

		if (chan_tag != expect)
		{
			errs	= 1;
			printf(	" FAIL <---  (Lost Synchronozation: [%ld] = 0x%08lX, [%ld] = 0x%08lX)\n",
					index - 1,
					(long) last,
					index,
					(long) data);
		}
	}

	return(errs);
}



//*****************************************************************************
static int _save_data(const args_t* args, int chans, int errs)
{
	char		buf[64];
	FILE*		file;
	long		l;
	u32			last		= 0xFFFFFFFF;
	const char*	name		= "data.txt";
	long		samples		= sizeof(_buffer) / 4;
	int			tag_got;

	strcpy(buf, "Saving");

	if (args->force_save)
	{
		errs	= 0;
		strcat(buf, " (Forced)");
	}

	gsc_label(buf);

	for (;;)
	{
		if (errs)
		{
			printf("SKIPPED  (errors)\n");
			errs	= 0;
			break;
		}

		file	= fopen(name, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", name);
			errs	= 1;
			break;
		}

		for (l = 0; l < samples; l++)
		{
			tag_got	= (_buffer[l] >> 24) & 0xF;

			if ((l > 0) && (tag_got == 0))
				errs	+= _save_eol(name, file);

			errs	+= _save_value(args, name, file, _buffer[l]);
			errs	+= _validate_data(chans, last, l, _buffer[l]);
			last	= _buffer[l];
		}

		fclose(file);

		if (errs == 0)
			printf("PASS  (%s)\n", name);

		break;
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	s32	chans	= 32;
	int	errs	= 0;

	gsc_label("Capture & Save");
	printf("\n");
	gsc_label_level_inc();

	errs	+= dsi12wi_config_ai		(args->fd, -1, 1, args->fsamp);
	errs	+= dsi12wi_rx_io_mode		(args->fd, -1, 1, args->io_mode, NULL);
	errs	+= dsi12wi_data_width		(args->fd, -1, 1, args->width, NULL);
	errs	+= dsi12wi_range			(args->fd, -1, 1, args->v_range, NULL);
	errs	+= dsi12wi_data_format		(args->fd, -1, 1, args->data_format, NULL);
	errs	+= _channels				(args, &chans);
	errs	+= dsi12wi_rx_io_overflow	(args->fd, -1, 1, DSI12WI_IO_OVERFLOW_IGNORE, NULL);
	errs	+= dsi12wi_rx_io_underflow	(args->fd, -1, 1, DSI12WI_IO_UNDERFLOW_IGNORE, NULL);
	errs	+= dsi12wi_ai_buf_clear		(args->fd, -1, 1);
	errs	+= dsi12wi_ai_buf_overflow	(args->fd, -1, 1, DSI12WI_AI_BUF_OVERFLOW_CLEAR, NULL);
	errs	+= dsi12wi_ai_buf_underflow	(args->fd, -1, 1, DSI12WI_AI_BUF_UNDERFLOW_CLEAR, NULL);
	errs	+= dsi12wi_rx_io_timeout	(args->fd, -1, 1, 30, NULL);
	errs	+= _read_data				(args);
	errs	+= dsi12wi_ai_buf_overflow	(args->fd, -1, 1, DSI12WI_AI_BUF_OVERFLOW_TEST, NULL);
	errs	+= dsi12wi_ai_buf_underflow	(args->fd, -1, 1, DSI12WI_AI_BUF_UNDERFLOW_TEST, NULL);
	errs	+= _save_data				(args, chans, errs);

	gsc_label_level_dec();
	return(errs);
}



