// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/samples/savedata/main.h $
// $Rev: 52540 $
// $Date: 2023-03-02 14:58:02 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "24dsi12wrciepe_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	continuous;		// > 0 = ignore errors, < 0 = stop on errors
	s32	decimal;		// save the data in decimal format?
	s32	force_save;		// Save data even if there are errors?
	s32	fsamp;			// The desired sample rate.
	s32	index;			// device index
	s32	minute_limit;
	s32	repeat;			// repeat data retrieval this many times
	s32	tag_strip;		// Strip the channel tag from the saved data?
	s32	test_limit;

	int	fd;

	// Device Settings

	s32	data_format;
	s32	io_mode;
	s32	v_range;		// The desired voltage range
	s32	width;
} args_t;



// prototypes *****************************************************************

int	perform_tests(const args_t* args);



#endif
