// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/samples/rxrate/perform.c $
// $Rev: 52539 $
// $Date: 2023-03-02 14:57:45 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_1M	(1024L * 1024L)



// variables ******************************************************************

static u32	_rx[_1M];



//*****************************************************************************
static int _rate_test(const args_t* args, long get)
{
	os_time_ns_t	begin;
	os_time_ns_t	end;
	int				errs		= 0;
	long long		data_limit	= args->rx_mb * 1000000;
	long long		data_total	= 0;
	long			got;
	long long		ms;
	long long		ms_limit	= 1000 * args->seconds;
	long long		ms_total	= 0;
	double			rate;
	long long		total;

	gsc_label("Reading");
	os_time_get_ns(&begin);

	for (;;)
	{
		got	= dsi12wi_read(args->fd, _rx, get);

		if (got < 0)
		{
			errs++;
			break;
		}

		os_time_get_ns(&end);
		data_total	+= got;
		ms_total	= ((long long) end.tv_sec * 1000 + end.tv_nsec / 1000000)
					- ((long long) begin.tv_sec * 1000 + begin.tv_nsec / 1000000);

		if ((ms_total >= ms_limit) && (data_total >= data_limit))
			break;
	}

	printf(	"%s  (", errs ? "FAIL <---" : "PASS");

	// Samples
	total	= data_total;
	gsc_label_long_comma(total / 4);
	printf(" Samples, ");

	// Period
	ms	= ms_total;
	gsc_label_float_comma((double) ms / 1000, -1, 3);
	printf(" Seconds, ");

	// Rate
	ms		= (ms <= 0) ? 1 : ms;
	rate	= ((double) total * 1000000 / 4) / ms / 1000;
	gsc_label_float_comma(rate, -1, 3);
	printf(" S/S)\n");

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int		errs	= 0;
	long	get		= sizeof(_rx);

	errs	+= dsi12wi_config_ai		(args->fd, -1, 1, 105000L);
	errs	+= dsi12wi_rx_io_mode		(args->fd, -1, 1, args->io_mode, NULL);
	errs	+= dsi12wi_rx_io_overflow	(args->fd, -1, 1, DSI12WI_IO_OVERFLOW_IGNORE, NULL);
	errs	+= dsi12wi_rx_io_underflow	(args->fd, -1, 1, DSI12WI_IO_UNDERFLOW_IGNORE, NULL);

	gsc_label ("Read Rate");
	printf("(%d second minimum, %ld MB minimum)\n", args->seconds, (long) args->rx_mb);
	gsc_label_level_inc();

	errs	+= dsi12wi_ai_buf_clear		(args->fd, -1, 1);
	errs	+= dsi12wi_ai_buf_overflow	(args->fd, -1, 1, DSI12WI_AI_BUF_OVERFLOW_CLEAR, NULL);
	errs	+= dsi12wi_ai_buf_underflow	(args->fd, -1, 1, DSI12WI_AI_BUF_UNDERFLOW_CLEAR, NULL);

	errs	+= _rate_test(args, get);

	errs	+= dsi12wi_ai_buf_overflow	(args->fd, -1, 1, -1, NULL);
	errs	+= dsi12wi_ai_buf_underflow	(args->fd, -1, 1, -1, NULL);

	gsc_label_level_dec();
	return(errs);
}


