// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/samples/regs/perform.c $
// $Rev: 52538 $
// $Date: 2023-03-02 14:57:25 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Sample Application: source file

#include "main.h"



//*****************************************************************************
static void _dump_gsc(int fd)
{
	dsi12wi_reg_list(fd, 0);
}



//*****************************************************************************
static void _dump_gsc_detail(int fd)
{
	dsi12wi_reg_list(fd, 1);
}



//*****************************************************************************
static void _dump_pci(int fd)
{
	gsc_reg_plx9056_list_pci(fd, dsi12wi_reg_read);
}



//*****************************************************************************
static void _dump_plx(int fd)
{
	gsc_reg_plx9056_list_plx(fd, dsi12wi_reg_read);
}



//*****************************************************************************
static void _id_device(int fd)
{
	dsi12wi_id_device(fd, -1, 1);
}



//*****************************************************************************
static void _id_driver(int fd)
{
	os_id_driver(dsi12wi_open, dsi12wi_read, dsi12wi_close);
}



//*****************************************************************************
static void _id_host(int fd)
{
	os_id_host();
}



//*****************************************************************************
static void _dump_everything(int fd)
{
	_id_host(fd);
	printf("\n");

	_id_driver(fd);
	printf("\n");

	_id_device(fd);
	printf("\n");

	_dump_pci(fd);
	printf("\n");

	_dump_plx(fd);
	printf("\n");

	_dump_gsc_detail(fd);
	printf("\n");
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	static const menu_item_t	list[]	=
	{
		// name								func
		{ "Dump Everything",				_dump_everything	},
		{ "Host OS Identification",			_id_host			},
		{ "Driver Identification",			_id_driver			},
		{ "Device Identification",			_id_device			},
		{ "PCI Register Dump",				_dump_pci			},
		{ "PLX Register Dump",				_dump_plx			},
		{ "GSC Register Dump",				_dump_gsc			},
		{ "GSC Register Detail Dump",		_dump_gsc_detail	},
		{ "Edit GSC Register By Name",		reg_mod_by_name		},
		{ "Edit GSC Register By Offset",	reg_mod_by_offset	},
		{ NULL,								NULL				}
	};

	static const menu_t	menu	=
	{
		/* title	*/	"Main Menu",
		/* list		*/	list
	};

	printf("\n\n");
	printf("Register Access Application\n");
	menu_call(args->fd, &menu);
	return(0);
}


