// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/samples/regs/main.h $
// $Rev: 52538 $
// $Date: 2023-03-02 14:57:25 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Sample Application: header file

#ifndef	__MAIN_H__
#define	__MAIN_H__

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "24dsi12wrciepe_main.h"



// macros *********************************************************************

#define	SIZEOF_ARRAY(a)			(sizeof((a)) / sizeof((a)[0]))



// data types *****************************************************************

typedef struct
{
	// Application Settings

	s32	index;			// device index

	int	fd;

	// Device Settings

} args_t;

typedef struct
{
	const char*	name;				// NULL terminates list.
	void		(*func)(int fd);	// NULL terminates list.
} menu_item_t;

typedef struct
{
	const char*			title;
	const menu_item_t*	list;
} menu_t;



// prototypes *****************************************************************

void	menu_call(int fd, const menu_t* menu);
int		menu_select(const menu_t* menu);

int		perform_tests(const args_t* args);

void	reg_mod_by_name(int fd);
void	reg_mod_by_offset(int fd);



#endif
