// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/samples/id/perform.c $
// $Rev: 52537 $
// $Date: 2023-03-02 14:57:08 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Sample Application: source file

#include "main.h"



//*****************************************************************************
static void _voltage_ranges(void)
{
	gsc_label("Voltage Ranges");
	printf("+-10V, +-1V +-0.1V, +-0.01V\n");
}



//*****************************************************************************
static void _input_modes(void)
{
	gsc_label("Input Modes");
	printf("Differential, Zero Test, +Vref Test\n");
}



//*****************************************************************************
static int _id_device_bcfgr(const args_t* args)
{
	gsc_reg_def_t			list[2]	= { { NULL }, { NULL } };
	const gsc_reg_def_t*	ptr;

	int	errs	= 0;

	printf("\n");
	ptr	= dsi12wi_reg_get_def_id(DSI12WI_GSC_BCFGR);

	if (ptr)
	{
		list[0]	= ptr[0];
		errs	= gsc_reg_list(args->fd, list, 1, dsi12wi_reg_read);
	}
	else
	{
		errs++;
		printf(	"FAIL <---  (%d. dsi12wi_reg_get_def_id, DSI12WI_GSC_BCFGR)\n",
				__LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _register_map(const args_t* args)
{
	int	errs;

	printf("\n");
	errs	= dsi12wi_reg_list(args->fd, args->detail);
	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;
	int	i;

	gsc_label("Device Features");
	printf("\n");

	gsc_label_level_inc();

	_input_modes();
	_voltage_ranges();

	for (i = 0; i < DSI12WI_QUERY_LAST; i++)
		errs	+= dsi12wi_query(args->fd, -1, 1, i, NULL);

	gsc_label_level_dec();

	errs	+= _id_device_bcfgr(args);
	errs	+= _register_map(args);

	return(errs);
}


