// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/samples/fsamp/perform.c $
// $Rev: 52536 $
// $Date: 2023-03-02 14:56:49 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	FILE_NAME				"fsamp.txt"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int		errs	= 0;
	FILE*	file	= NULL;
	s32		fsamp;
	s32		max		= 0;
	s32		min		= 0;
	s32		mode;
	s32		ndiv;
	s32		nref;
	s32		nvco;
	double	rate;

	gsc_label("Fsamp Computation");
	printf("\n");
	gsc_label_level_inc();

	if (args->range == 0)
	{
		min		= args->fsamp;
		max		= args->fsamp;
	}
	else
	{
		errs	+= dsi12wi_query(args->fd, -1, 0, DSI12WI_QUERY_FSAMP_MAX, &max);
		errs	+= dsi12wi_query(args->fd, -1, 0, DSI12WI_QUERY_FSAMP_MIN, &min);
	}

	if (args->save)
	{
		file	= fopen(FILE_NAME, "w+b");

		if (file == NULL)
		{
			printf("FAIL <---  (unable to create %s)\n", FILE_NAME);
			errs	= 1;
		}
		else
		{
			fprintf(file, "# 24DSI12WRCIEPE Scan Rates\n");
			fprintf(file, "# Request   Produced\n");
			fprintf(file, "# ========  ==========\n");
		}
	}

	for (fsamp = min; fsamp <= max; fsamp++)
	{
		errs	+= dsi12wi_fsamp_ai_compute(args->fd, -1, 1, fsamp, &mode, &nvco, &nref, &ndiv, &rate);

		if (file)
			fprintf(file, "%10ld  %10.3f\n", (long) fsamp, (double) rate);
	}

	if (file)
		fclose(file);

	gsc_label_level_dec();
	return(errs);
}


