// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/utils/pci_plx/gsc_utils_pci.h $
// $Rev: 50958 $
// $Date: 2022-04-25 08:19:35 -0500 (Mon, 25 Apr 2022) $

// OS & Device Independent: Utility: header file

#ifndef	__GSC_UTILS_PCI_H__
#define	__GSC_UTILS_PCI_H__

#include "gsc_pci9056.h"
#include "gsc_pci9060es.h"
#include "gsc_pci9080.h"
#include "gsc_pci9656.h"
#include "gsc_pex8111.h"
#include "gsc_pex8112.h"



// prototypes *****************************************************************

const gsc_reg_def_t*	gsc_reg_pex8111_get_def_id(int reg);
const char*				gsc_reg_pex8111_get_desc(u32 reg);
const char*				gsc_reg_pex8111_get_name(u32 reg);
int						gsc_reg_pex8111_list_pci(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));
int						gsc_reg_pex8111_list_plx(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));

const gsc_reg_def_t*	gsc_reg_pex8112_get_def_id(int reg);
const char*				gsc_reg_pex8112_get_desc(u32 reg);
const char*				gsc_reg_pex8112_get_name(u32 reg);
int						gsc_reg_pex8112_list_pci(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));
int						gsc_reg_pex8112_list_plx(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));

const gsc_reg_def_t*	gsc_reg_plx9056_get_def_id(int reg);
const char*				gsc_reg_plx9056_get_desc(u32 reg);
const char*				gsc_reg_plx9056_get_name(u32 reg);
int						gsc_reg_plx9056_list_pci(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));
int						gsc_reg_plx9056_list_plx(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));

const gsc_reg_def_t*	gsc_reg_plx9060es_get_def_id(int reg);
const char*				gsc_reg_plx9060es_get_desc(u32 reg);
const char*				gsc_reg_plx9060es_get_name(u32 reg);
int						gsc_reg_plx9060es_list_pci(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));
int						gsc_reg_plx9060es_list_plx(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));

const gsc_reg_def_t*	gsc_reg_plx9080_get_def_id(int reg);
const char*				gsc_reg_plx9080_get_desc(u32 reg);
const char*				gsc_reg_plx9080_get_name(u32 reg);
int						gsc_reg_plx9080_list_pci(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));
int						gsc_reg_plx9080_list_plx(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));

const gsc_reg_def_t*	gsc_reg_plx9656_get_def_id(int reg);
const char*				gsc_reg_plx9656_get_desc(u32 reg);
const char*				gsc_reg_plx9656_get_name(u32 reg);
int						gsc_reg_plx9656_list_pci(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));
int						gsc_reg_plx9656_list_plx(int fd, int (reg_read)(int fd, int index, int verbose, u32 reg, u32* value));



#endif
