// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/include/24dsi12wrciepe_utils.h $
// $Rev: 52534 $
// $Date: 2023-03-02 14:53:43 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Utilities: header file

#ifndef	__24DSI12WRCIEPE_UTILS_H__
#define	__24DSI12WRCIEPE_UTILS_H__

#include "24dsi12wrciepe_api.h"
#include "gsc_utils.h"
#include "gsc_utils_pci.h"



// prototypes *****************************************************************

// API utility services

int	dsi12wi_close_util			(int fd, int index, int verbose);
int dsi12wi_init_util			(int verbose);
int dsi12wi_ioctl_util			(int fd, int index, int verbose, int request, void* arg);
int	dsi12wi_open_util			(int device, int share, int index, int verbose, int* fd);
int	dsi12wi_read_util			(int fd, int index, int verbose, void* dst, size_t bytes);

// IOCTL utility services

int	dsi12wi_adc_mode			(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_ADC_MODE
int	dsi12wi_ai_buf_clear		(int fd, int index, int verbose);								// DSI12WI_IOCTL_AI_BUF_CLEAR
int	dsi12wi_ai_buf_enable		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_AI_BUF_ENABLE
int	dsi12wi_ai_buf_fill_lvl		(int fd, int index, int verbose, s32* get);						// DSI12WI_IOCTL_AI_BUF_FILL_LVL
int	dsi12wi_ai_buf_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_AI_BUF_OVERFLOW
int	dsi12wi_ai_buf_thr_sts		(int fd, int index, int verbose, s32* get);						// DSI12WI_IOCTL_AI_BUF_THR_STS
int	dsi12wi_ai_buf_thresh		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_AI_BUF_THRESH
int	dsi12wi_ai_buf_underflow	(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_AI_BUF_UNDERFLOW
int	dsi12wi_ai_channel_tag		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_AI_CHANNEL_TAG
int	dsi12wi_ai_mode				(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_AI_MODE
int	dsi12wi_auto_cal			(int fd, int index, int verbose);								// DSI12WI_IOCTL_AUTO_CAL
int	dsi12wi_auto_cal_sts		(int fd, int index, int verbose, s32* get);						// DSI12WI_IOCTL_AUTO_CAL_STS
int	dsi12wi_aux_clk_ctl_mode	(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_AUX_CLK_CTL_MODE
int	dsi12wi_aux_sync_ctl_mode	(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_AUX_SYNC_CTL_MODE
int	dsi12wi_burst_enable		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_BURST_ENABLE
int	dsi12wi_burst_rate_div		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_BURST_RATE_DIV
int	dsi12wi_burst_size			(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_BURST_SIZE
int	dsi12wi_burst_timer			(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_BURST_TIMER
int	dsi12wi_burst_trigger		(int fd, int index, int verbose);								// DSI12WI_IOCTL_BURST_TRIGGER
int	dsi12wi_ch_grp_0_src		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_CH_GRP_0_SRC
int	dsi12wi_ch_grp_1_src		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_CH_GRP_1_SRC
int	dsi12wi_channels_ready		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_CHANNELS_READY
int	dsi12wi_clock_control_mode	(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_CLOCK_CONTROL_MODE
int	dsi12wi_coupling_mode		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_COUPLING_MODE
int	dsi12wi_data_format			(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_DATA_FORMAT
int	dsi12wi_data_width			(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_DATA_WIDTH
int	dsi12wi_excitation_current	(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_EXCITATION_CURRENT
int	dsi12wi_ext_clk_src			(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_EXT_CLK_SRC
int	dsi12wi_ext_sync_dir		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_EXT_SYNC_DIR
int	dsi12wi_initialize			(int fd, int index, int verbose);								// DSI12WI_IOCTL_INITIALIZE
int	dsi12wi_input_comp			(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_INPUT_COMP
int	dsi12wi_irq_sel				(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_IRQ_SEL
int	dsi12wi_ndiv				(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_NDIV
int	dsi12wi_nref				(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_NREF
int	dsi12wi_nvco				(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_NVCO
int	dsi12wi_query				(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_QUERY
int	dsi12wi_range				(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_RANGE
int	dsi12wi_reg_mod				(int fd, int index, int verbose, u32 reg, u32 value, u32 mask);	// DSI12WI_IOCTL_REG_MOD
int	dsi12wi_reg_read			(int fd, int index, int verbose, u32 reg, u32* value);			// DSI12WI_IOCTL_REG_READ
int	dsi12wi_reg_write			(int fd, int index, int verbose, u32 reg, u32 value);			// DSI12WI_IOCTL_REG_WRITE
int	dsi12wi_rx_io_abort			(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_RX_IO_ABORT
int	dsi12wi_rx_io_mode			(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_RX_IO_MODE
int	dsi12wi_rx_io_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_RX_IO_OVERFLOW
int	dsi12wi_rx_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_RX_IO_TIMEOUT
int	dsi12wi_rx_io_underflow		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_RX_IO_UNDERFLOW
int	dsi12wi_sw_sync				(int fd, int index, int verbose);								// DSI12WI_IOCTL_SW_SYNC
int	dsi12wi_sw_sync_mode		(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_SW_SYNC_MODE
int	dsi12wi_sync_control_mode	(int fd, int index, int verbose, s32 set, s32* get);			// DSI12WI_IOCTL_SYNC_CONTROL_MODE
int	dsi12wi_wait_cancel			(int fd, int index, int verbose, gsc_wait_t* wait);				// DSI12WI_IOCTL_WAIT_CANCEL
int	dsi12wi_wait_event			(int fd, int index, int verbose, gsc_wait_t* wait);				// DSI12WI_IOCTL_WAIT_EVENT
int	dsi12wi_wait_status			(int fd, int index, int verbose, gsc_wait_t* wait);				// DSI12WI_IOCTL_WAIT_STATUS

// Auxiliary utility services

int	dsi12wi_config_ai			(int fd, int index, int verbose, s32 fsamp);
int	dsi12wi_fsamp_ai_compute	(int fd, int index, int verbose, s32 fsamp, s32* mode, s32* nvco, s32* nref, s32* ndiv, double* rate);
int	dsi12wi_fsamp_ai_report		(int fd, int index, int verbose, int chan, s32* fsamp);
int	dsi12wi_fsamp_ai_report_all	(int fd, int index, int verbose, s32* fsamp);
int	dsi12wi_id_device			(int fd, int index, int verbose);

int	dsi12wi_count_boards		(int verbose, s32* get);
int	dsi12wi_reg_list			(int fd, int detail);

const gsc_reg_def_t*			dsi12wi_reg_get_def_id			(u32 reg);
const gsc_reg_def_t*			dsi12wi_reg_get_def_index		(int index);
const char*						dsi12wi_reg_get_desc			(u32 reg);
const char*						dsi12wi_reg_get_name			(u32 reg);



#endif


