// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/24DSI12WRCIEPE/24DSI12WRCIEPE_linux_1.x.x.x_gsc_dn/driver/irq.c $
// $Rev: 52546 $
// $Date: 2023-03-02 15:06:54 -0600 (Thu, 02 Mar 2023) $

// 24DSI12WRCIEPE: Device Driver: source file

#include "main.h"



// macros *********************************************************************

#define	IRQ_ACTIVE				0x0800	// BCTLR



//*****************************************************************************
void dev_irq_isr_local_handler(dev_data_t* dev)
{
	u32	bctlr;
	u32	req;

	bctlr	= os_reg_mem_rx_u32(NULL, dev->vaddr.gsc_bctlr_32);

	if (bctlr & IRQ_ACTIVE)
	{
		// Clear the interrupt.
		bctlr	^= IRQ_ACTIVE;
		os_reg_mem_tx_u32(NULL, dev->vaddr.gsc_bctlr_32, bctlr);

		// Resume any waiting threads.
		req	= GSC_FIELD_DECODE(bctlr, 10, 8);

		switch (req)
		{
			default:

				gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
				break;

			case DSI12WI_IRQ_INIT_DONE:

				gsc_wait_resume_irq_gsc(dev, DSI12WI_WAIT_GSC_INIT_DONE);
				break;

			case DSI12WI_IRQ_AUTO_CAL_DONE:

				gsc_wait_resume_irq_gsc(dev, DSI12WI_WAIT_GSC_AUTO_CAL_DONE);
				break;

			case DSI12WI_IRQ_CHAN_READY:

				gsc_wait_resume_irq_gsc(dev, DSI12WI_WAIT_GSC_CHAN_READY);
				break;

			case DSI12WI_IRQ_AI_BUF_THRESH_L2H:

				gsc_wait_resume_irq_gsc(dev, DSI12WI_WAIT_GSC_AI_BUF_THRESH_L2H);
				break;

			case DSI12WI_IRQ_AI_BUF_THRESH_H2L:

				gsc_wait_resume_irq_gsc(dev, DSI12WI_WAIT_GSC_AI_BUF_THRESH_H2L);
				break;

			case DSI12WI_IRQ_AI_BURST_DONE:

				gsc_wait_resume_irq_gsc(dev, DSI12WI_WAIT_GSC_AI_BURST_DONE);
				break;
		}
	}
	else
	{
		// We don't know the source of the interrupt.
		gsc_wait_resume_irq_main(dev, GSC_WAIT_MAIN_SPURIOUS);
	}
}



//*****************************************************************************
int dev_irq_create(dev_data_t* dev)
{
	int	ret;

	os_reg_mem_tx_u32(dev, dev->vaddr.gsc_bctlr_32, 0);
	ret	= gsc_irq_create(dev);
	return(ret);
}



//*****************************************************************************
void dev_irq_destroy(dev_data_t* dev)
{
	if (dev->vaddr.gsc_bctlr_32)
		os_reg_mem_tx_u32(dev, dev->vaddr.gsc_bctlr_32, 0);

	gsc_irq_destroy(dev);
}


