// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/utils/util_wait_event.c $
// $Rev: 50672 $
// $Date: 2022-03-02 17:25:26 -0600 (Wed, 02 Mar 2022) $

// 18AISS6C: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss6c_wait_event
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS6C_IOCTL_WAIT_EVENT service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		wait	This is the crieteria to use.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int aiss6c_wait_event(int fd, int index, int verbose, gsc_wait_t* wait)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Wait Event", index);

	ret		= aiss6c_ioctl(fd, AISS6C_IOCTL_WAIT_EVENT, wait);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}



