// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/utils/util_id.c $
// $Rev: 53510 $
// $Date: 2023-08-03 10:05:51 -0500 (Thu, 03 Aug 2023) $

// 18AISS6C: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	_id_device_pci
*
*	Purpose:
*
*		Identify the device using the PCI registers.
*
*	Arguments:
*
*		fd		The handle used to access the device.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

static int _id_device_pci(int fd)
{
	int	errs;
	u32	reg;

	gsc_label("Vendor ID");
	errs	= aiss6c_reg_read(fd, -1, 0, GSC_PCI_9056_VIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Device ID");
	errs	+= aiss6c_reg_read(fd, -1, 0, GSC_PCI_9056_DIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x9056)
	{
		printf("(PCI9056)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Sub Vendor ID");
	errs	+= aiss6c_reg_read(fd, -1, 0, GSC_PCI_9056_SVID, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	gsc_label("Subsystem ID");
	errs	+= aiss6c_reg_read(fd, -1, 0, GSC_PCI_9056_SID, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x3467)
	{
		printf("(18AISS6C)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	return(errs);
}



/******************************************************************************
*
*	Function:	aiss6c_id_device
*
*	Purpose:
*
*		Identify the device.
*
*	Arguments:
*
*		fd		The handle to use to access the device.
*
*		index	The index of the device or -1 if we don't care.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int aiss6c_id_device(int fd, int index, int verbose)
{
	s32			device_type;
	int			errs;
	const char*	psz			= "";

	if (verbose)
		gsc_label_index("Device", index);

	errs	= aiss6c_query(fd, -1, 0, AISS6C_QUERY_DEVICE_TYPE, &device_type);

	if (errs)
	{
		if (verbose)
			printf("FAIL <---  (query error)\n");
	}
	else
	{
		switch (device_type)
		{
			default:

				errs	= 1;

				if (verbose)
				{
					printf(	"FAIL <---  (unexpected device type: %ld)",
							(long) device_type);
				}

				break;

			case GSC_DEV_TYPE_18AISS6C:	psz	= "18AISS6C";	break;
		}

		if ((verbose) && (errs == 0))
			printf("%s\n", psz);

		gsc_label_level_inc();

		errs	+= _id_device_pci(fd);

		gsc_label_level_dec();
	}

	return(errs);
}


