// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/utils/util_config_aux.c $
// $Rev: 53510 $
// $Date: 2023-08-03 10:05:51 -0500 (Thu, 03 Aug 2023) $

// 18AISS6C: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss6c_config_aux
*
*	Purpose:
*
*		Configure the given device's auxiliary options.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int aiss6c_config_aux(int fd, int index, int verbose)
{
	int	errs	= 0;

	if (verbose)
	{
		gsc_label_index("Auxiliary Configuration", index);
		printf("\n");
		gsc_label_level_inc();
	}

	// Settings must be applied after the initialization call!

	errs	+= aiss6c_aux_clk_mode	(fd, index, verbose, AISS6C_AUX_CLK_MODE_DISABLE,	NULL);
	errs	+= aiss6c_aux_in_pol	(fd, index, verbose, AISS6C_AUX_IN_POL_L2H,			NULL);
	errs	+= aiss6c_aux_noise		(fd, index, verbose, AISS6C_AUX_NOISE_LOW,			NULL);
	errs	+= aiss6c_aux_out_pol	(fd, index, verbose, AISS6C_AUX_OUT_POL_L2H,		NULL);
	errs	+= aiss6c_aux_sync_mode	(fd, index, verbose, AISS6C_AUX_SYNC_MODE_DISABLE,	NULL);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


