// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/utils/util_aux_noise.c $
// $Rev: 50672 $
// $Date: 2022-03-02 17:25:26 -0600 (Wed, 02 Mar 2022) $

// 18AISS6C: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss6c_aux_noise
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS6C_IOCTL_AUX_NOISE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	aiss6c_aux_noise(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr		= buf;
	int			ret;

	if (verbose)
		gsc_label_index("Aux Noise", index);

	ret		= aiss6c_ioctl(fd, AISS6C_IOCTL_AUX_NOISE, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case AISS6C_AUX_NOISE_LOW:

			ptr	= "Low";
			break;

		case AISS6C_AUX_NOISE_HIGH:

			ptr	= "High";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


