// $URL:$
// $Rev:$
// $Date:$

// 18AISS6C: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss6c_autocal_status
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS6C_IOCTL_AUTOCAL_STATUS service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	aiss6c_autocal_status(int fd, int index, int verbose, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr;
	int			ret;
	s32			set		= -1;

	if (verbose)
		gsc_label_index("AO Clock Status", index);

	ret		= aiss6c_ioctl(fd, AISS6C_IOCTL_AUTOCAL_STATUS, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			ptr	= buf;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case -1:

			ptr	= "This service is not supported by this device.";
			break;

		case AISS6C_AUTOCAL_STATUS_ACTIVE:

			ptr	= "Active";
			break;

		case AISS6C_AUTOCAL_STATUS_FAIL:

			ptr	= "Failed";
			break;

		case AISS6C_AUTOCAL_STATUS_PASS:

			ptr	= "Passed";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


