// $URL:$
// $Rev:$
// $Date:$

// 18AISS6C: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss6c_autocal
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS6C_IOCTL_AUTOCAL service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	aiss6c_autocal(int fd, int index, int verbose)
{
	int	errs;
	int	ret;

	if (verbose)
		gsc_label_index("Autocalibrate", index);

	ret		= aiss6c_ioctl(fd, AISS6C_IOCTL_AUTOCAL, NULL);
	errs	= ret ? 1 : 0;

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}


