// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/utils/util_ai_thresh_sts.c $
// $Rev: 50672 $
// $Date: 2022-03-02 17:25:26 -0600 (Wed, 02 Mar 2022) $

// 18AISS6C: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss6c_ai_thresh_sts
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS6C_IOCTL_AI_THRESH_STS service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*				This is for display purposes only.
*
*		verbose	Work verbosely?
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	aiss6c_ai_thresh_sts(int fd, int index, int verbose, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr		= buf;
	int			ret;
	s32			set;

	if (verbose)
		gsc_label_index("AI Threshold Status", index);

	ret		= aiss6c_ioctl(fd, AISS6C_IOCTL_AI_THRESH_STS, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case AISS6C_THRESH_STS_CLEAR:

			ptr	= "Clear";
			break;


		case AISS6C_THRESH_STS_SET:

			ptr	= "Set";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


