// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/utils/util_ai_burst_enable.c $
// $Rev: 53510 $
// $Date: 2023-08-03 10:05:51 -0500 (Thu, 03 Aug 2023) $

// 18AISS6C: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss6c_ai_burst_enable
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS6C_IOCTL_AI_BURST_ENABLE service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
8		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int	aiss6c_ai_burst_enable(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr		= buf;

	if (verbose)
		gsc_label_index("AI Burst Enable", index);

	errs	= aiss6c_ioctl(fd, AISS6C_IOCTL_AI_BURST_ENABLE, &set);

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case AISS6C_BURST_ENABLE_NO:

			ptr	= "No, Disabled";
			break;

		case AISS6C_BURST_ENABLE_YES:

			ptr	= "Yes, Enabled";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


