// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/utils/util_ai_buf_overflow.c $
// $Rev: 53510 $
// $Date: 2023-08-03 10:05:51 -0500 (Thu, 03 Aug 2023) $

// 18AISS6C: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss6c_ai_buf_overflow
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS6C_IOCTL_AI_BUF_OVERFLOW service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*		set		This is the value to apply.
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int	aiss6c_ai_buf_overflow(int fd, int index, int verbose, s32 set, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr		= buf;

	if (verbose)
		gsc_label_index("AI Buffer Overflow", index);

	errs	= aiss6c_ioctl_dsl(fd, AISS6C_IOCTL_AI_BUF_OVERFLOW, &set);

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case AISS6C_BUF_OVERFLOW_NO:

			ptr	= "No";
			break;

		case AISS6C_BUF_OVERFLOW_YES:

			ptr	= "Yes";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


