// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/utils/util_ai_buf_level.c $
// $Rev: 53510 $
// $Date: 2023-08-03 10:05:51 -0500 (Thu, 03 Aug 2023) $

// 18AISS6C: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss6c_ai_buf_level
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS6C_IOCTL_AI_BUF_LEVEL service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*		get		The results are reported here. This may be NULL.
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int	aiss6c_ai_buf_level(int fd, int index, int verbose, s32* get)
{
	int	errs;
	s32	set;

	if (verbose)
		gsc_label_index("AI Buffer Level", index);

	errs	= aiss6c_ioctl_dsl(fd, AISS6C_IOCTL_AI_BUF_LEVEL, &set);

	if (verbose)
		printf("%s  (0x%lX)\n", errs ? "FAIL <---" : "PASS", (long) set);

	if (get)
		get[0]	= set;

	return(errs);
}


