// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/utils/util_ai_buf_clear.c $
// $Rev: 53510 $
// $Date: 2023-08-03 10:05:51 -0500 (Thu, 03 Aug 2023) $

// 18AISS6C: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	aiss6c_ai_buf_clear
*
*	Purpose:
*
*		Provide a visual wrapper for the AISS6C_IOCTL_AI_BUF_CLEAR service.
*
*	Arguments:
*
*		fd		The handle to use to access the driver.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely?
*
*	Returned:
*
*		>= 0	The number of errors encountered here.
*
******************************************************************************/

int	aiss6c_ai_buf_clear(int fd, int index, int verbose)
{
	int	errs;

	if (verbose)
		gsc_label_index("AI Buffer Clear", index);

	errs	= aiss6c_ioctl(fd, AISS6C_IOCTL_AI_BUF_CLEAR, NULL);

	if (verbose)
		printf("%s\n", errs ? "FAIL <---" : "PASS");

	return(errs);
}


