// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/samples/signals/perform.c $
// $Rev: 53508 $
// $Date: 2023-08-03 09:59:49 -0500 (Thu, 03 Aug 2023) $

// 18AISS6C: Sample Application: source file

#include "main.h"



//*****************************************************************************
int perform_tests(const args_t* args)
{
	char	buf[64];
	int		errs	= 0;

	//===============================================================
	gsc_label("Setup");
	printf("\n");
	gsc_label_level_inc();

	errs	+= aiss6c_initialize		(args->fd, -1, 1);

	gsc_label_level_dec();

	//===============================================================
	gsc_label("Clock Output");
	printf("\n");
	gsc_label_level_inc();

	errs	+= aiss6c_ai_clk_src		(args->fd, -1, 1, AISS6C_AI_CLK_SRC_RAG, NULL);
	errs	+= aiss6c_ai_warp_mode		(args->fd, -1, 1, AISS6C_AI_WARP_MODE_DISABLE, NULL);
	errs	+= aiss6c_gen_a_ndiv		(args->fd, -1, 1, 4500, NULL);
	errs	+= aiss6c_gen_a_enable		(args->fd, -1, 1, AISS6C_GEN_ENABLE_YES, NULL);

	gsc_label_level_dec();

	//===============================================================
	gsc_label("Input Trigger Out");
	printf("\n");
	gsc_label_level_inc();

	errs	+= aiss6c_ai_burst_size		(args->fd, -1, 1, 1, NULL);
	errs	+= aiss6c_ai_burst_enable	(args->fd, -1, 1, AISS6C_BURST_ENABLE_YES, NULL);
	errs	+= aiss6c_ai_trig_src		(args->fd, -1, 1, AISS6C_AI_TRIG_SRC_RBG, NULL);
	errs	+= aiss6c_gen_b_ndiv		(args->fd, -1, 1, 9000, NULL);
	errs	+= aiss6c_gen_b_enable		(args->fd, -1, 1, AISS6C_GEN_ENABLE_YES, NULL);
	gsc_label_level_dec();

	//===============================================================
	sprintf(buf, "Waiting (%ld sec%s)", (long) args->seconds, (args->seconds == 1) ? "" : "s");
	gsc_label(buf);
	fflush(stdout);
	os_sleep_ms(args->seconds * 1000);
	printf("Done\n");

	errs	+= aiss6c_initialize		(args->fd, -1, 1);

	return(errs);
}



