// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/samples/id/perform.c $
// $Rev: 53504 $
// $Date: 2023-08-03 09:58:47 -0500 (Thu, 03 Aug 2023) $

// 18AISS6C: Sample Application: source file

#include "main.h"



//*****************************************************************************
static void _input_modes(void)
{
	gsc_label("Input Modes");
	printf("System Inputs, Zero Test, +Vref Test\n");
}



//*****************************************************************************
static void _clocking_sources(void)
{
	gsc_label("Clocking Sources");
	printf("Rate Generator(s), External, Software\n");

	gsc_label("Trigger Sources");
	printf("Rate Generator(s), External, Software\n");
}



//*****************************************************************************
static void _sampling_modes(void)
{
	gsc_label("Input Sampling Modes");
	printf("Continuous, Burst\n");
}



//*****************************************************************************
static void _digital_io(void)
{
	gsc_label("Digital I/O");
	printf("8 Bi-Directional Signals\n");
}



//*****************************************************************************
static int _id_device_reg(const args_t* args)
{
	int						errs;
	gsc_reg_def_t			list[2]	= { { NULL }, { NULL } };
	const gsc_reg_def_t*	ptr;

	printf("\n");
	ptr	= aiss6c_reg_get_def_id(AISS6C_GSC_ACR);

	if (ptr)
	{
		list[0]	= ptr[0];
		errs	= gsc_reg_list(args->fd, list, 1, aiss6c_reg_read);
	}
	else
	{
		errs	= 1;
		printf(	"FAIL <---  (%d. aiss6c_reg_get_def_id, AISS6C_GSC_ACR)\n",
				__LINE__);
	}

	return(errs);
}



//*****************************************************************************
static int _register_map(const args_t* args)
{
	int	errs;

	printf("\n");
	errs	= aiss6c_reg_list(args->fd, args->detail);
	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int	errs	= 0;
	int	i;

	gsc_label("Device Features");
	printf("\n");

	gsc_label_level_inc();

	_input_modes();
	_clocking_sources();
	_sampling_modes();
	_digital_io();

	for (i = 0; i < AISS6C_IOCTL_QUERY_LAST; i++)
		errs	+= aiss6c_query(args->fd, -1, 1, i, NULL);

	gsc_label_level_dec();

	errs	+= _id_device_reg(args);
	errs	+= _register_map(args);
	printf("\n");

	return(errs);
}


