// $URL: http://subversion:8080/svn/gsc/trunk/drivers/gsc_common/utils/gsc_utils.h $
// $Rev: 52328 $
// $Date: 2023-01-09 13:03:18 -0600 (Mon, 09 Jan 2023) $

// OS & Device Independent: Utility: header file

#ifndef	__GSC_UTILS_H__
#define	__GSC_UTILS_H__

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "os_utils.h"



// macros *********************************************************************

#define	BUF_MAN_USER_AREA_SIZE	32		// Apps can change this as needed and rebuild.



// data types *****************************************************************

typedef enum
{
	GSC_ARG_DEV_INDEX,	// index of device/board to access, values[0] is max quantity allowed, MUST LIST LAST
	GSC_ARG_S32_FLAG,	// values[0] is assigned to var
	GSC_ARG_S32_MASK,	// arg is a decimal, values[0] is mask of valid bits
	GSC_ARG_S32_MIN,	// arg is a decimal, values[0] is minimum
	GSC_ARG_S32_RANGE,	// arg is a decimal, values[0] is minimum, values[1] is maximum
	GSC_ARG_DEV_NOTE,	// Report the description only.
	GSC_ARG_STR_PTR		// arg is a string, values are unused, var is char**
} gsc_arg_type_t;

typedef struct
{
	gsc_arg_type_t	type;
	s32*			var;	// The command line argument value is tstored here.
	const char*		arg;	// Portion which must match. "#" is added automatically
	s32				values[2];
	const char*		desc;
} gsc_arg_item_t;

typedef struct
{
	const char*				name;
	const char*				desc;
	unsigned int			qty;	// size of following list
	const gsc_arg_item_t*	list;
} gsc_arg_set_t;

typedef struct
{
	void*	buffer;	// Data goes here.
	size_t	size;	// This is the size of the buffer in bytes.
	size_t	offset;	// This is where the data begins.
	u32		count;	// This is the number of bytes of data available beginning at offset.
	int		eof;	// Have we hit the end of an input file?
	u8		user_area[BUF_MAN_USER_AREA_SIZE];	// Reserved for application use.
} gsc_buf_man_t;

typedef struct		// For listing register values.
{
	const char*	name;
	int			reg;
	int			err;
	u32			value;
	int			ask_support;	// Call below function for this.
	int			(*decode)(int fd, int supported, u32 value, int width);
	const char*	desc;			// Description
} gsc_reg_def_t;



// variables ******************************************************************

extern	const int* const	gsc_label_level;
extern	const int* const	gsc_label_width;



// prototypes *****************************************************************

int			gsc_args_parse(int argc, char* const * const argv, const gsc_arg_set_t* set);

int			gsc_buf_man_free_all(void);
int			gsc_buf_man_init(void);
int			gsc_buf_man_release_buffer(gsc_buf_man_t* bm);
int			gsc_buf_man_request_data(gsc_buf_man_t* bm);
int			gsc_buf_man_request_empty(gsc_buf_man_t* bm);
int			gsc_buf_man_setup(size_t qty, size_t size);
int			gsc_buf_man_stop(void);
int			gsc_buf_man_stats(void);

void		gsc_label(const char* label);
void		gsc_label_float_comma(double value, int len, int places);
void		gsc_label_float_comma_buf(double value, int len, int places, char* dest);
void		gsc_label_init(int width);
int			gsc_label_indent(int delta);
void		gsc_label_index(const char* label, int index);
void		gsc_label_level_dec(void);
void		gsc_label_level_inc(void);
void		gsc_label_long_comma(long long value);
void		gsc_label_long_comma_buf(long long value, char* buffer);
void		gsc_label_suffix(const char* label, const char* suffix);

size_t		gsc_time_delta_ms(void);
void		gsc_time_format_ms(long ms, char* dest, size_t size);
void		gsc_time_sleep_ms(long ms);

void		gsc_reg_field_show(
				int					label_width,
				int					name_width,
				u32					value,
				int					hi_bit,
				int					low_bit,
				int					eol,
				const char* const *	list,
				const char*			name);

int			gsc_reg_list(
				int				fd,
				gsc_reg_def_t*	list,
				int				detail,
				int				(reg_read)(int fd, int index, int verbose, u32 reg, u32* value));



#endif
