// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/include/18aiss6c_utils.h $
// $Rev: 53512 $
// $Date: 2023-08-03 10:09:07 -0500 (Thu, 03 Aug 2023) $

// 18AISS6C: Utilities: header file

#ifndef	__18AISS6C_UTILS_H__
#define	__18AISS6C_UTILS_H__

#include "18aiss6c_api.h"
#include "gsc_utils.h"
#include "gsc_utils_pci.h"



// prototypes *****************************************************************

// API utility services

int	aiss6c_close_util			(int fd, int index, int verbose);
int aiss6c_init_util			(int verbose);
int aiss6c_ioctl_util			(int fd, int index, int verbose, int request, void* arg);
int	aiss6c_open_util			(int device, int share, int index, int verbose, int* fd);
int	aiss6c_read_util			(int fd, int index, int verbose, void* dst, size_t bytes, size_t* got);

// IOCTL utility services

int	aiss6c_ai_buf_clear			(int fd, int index, int verbose);								// AISS6C_IOCTL_AI_BUF_CLEAR
int	aiss6c_ai_buf_level			(int fd, int index, int verbose, s32* get);						// AISS6C_IOCTL_AI_BUF_LEVEL
int	aiss6c_ai_buf_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_BUF_OVERFLOW
int	aiss6c_ai_buf_underflow		(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_BUF_UNDERFLOW
int	aiss6c_ai_burst_enable		(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_BURST_ENABLE
int	aiss6c_ai_burst_size		(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_BURST_SIZE
int	aiss6c_ai_burst_status		(int fd, int index, int verbose, s32* get);						// AISS6C_IOCTL_AI_BURST_STATUS
int	aiss6c_ai_chan_sel			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_CHAN_SEL
int	aiss6c_ai_clk_src			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_CLK_SRC
int	aiss6c_ai_config			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_CONFIG
int	aiss6c_ai_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_ENABLE
int	aiss6c_ai_filter			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_FILTER
int	aiss6c_ai_range				(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_RANGE
int	aiss6c_ai_sw_clock			(int fd, int index, int verbose);								// AISS6C_IOCTL_AI_SW_CLOCK
int	aiss6c_ai_sw_trigger		(int fd, int index, int verbose);								// AISS6C_IOCTL_AI_SW_TRIGGER
int	aiss6c_ai_thresh_lvl		(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_THRESH_LVL
int	aiss6c_ai_thresh_sts		(int fd, int index, int verbose, s32* get);						// AISS6C_IOCTL_AI_THRESH_STS
int	aiss6c_ai_trig_src			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_TRIG_SRC
int	aiss6c_ai_warp_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AI_WARP_MODE
int	aiss6c_autocal				(int fd, int index, int verbose);								// AISS6C_IOCTL_AUTOCAL
int	aiss6c_autocal_status		(int fd, int index, int verbose, s32* get);						// AISS6C_IOCTL_AUTOCAL_STATUS
int	aiss6c_aux_clk_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AUX_CLK_MODE
int	aiss6c_aux_in_pol			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AUX_IN_POL
int	aiss6c_aux_noise			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AUX_NOISE
int	aiss6c_aux_out_pol			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AUX_OUT_POL
int	aiss6c_aux_sync_mode		(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_AUX_SYNC_MODE
int	aiss6c_data_format			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_DATA_FORMAT
int	aiss6c_dio_dir_out			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_DIO_DIR_OUT
int	aiss6c_dio_read				(int fd, int index, int verbose, s32* get);						// AISS6C_IOCTL_DIO_READ
int	aiss6c_dio_write			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_DIO_WRITE
int	aiss6c_gen_a_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_GEN_A_ENABLE
int	aiss6c_gen_a_ndiv			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_GEN_A_NDIV
int	aiss6c_gen_b_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_GEN_B_ENABLE
int	aiss6c_gen_b_ndiv			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_GEN_B_NDIV
int	aiss6c_initialize			(int fd, int index, int verbose);								// AISS6C_IOCTL_INITIALIZE
int	aiss6c_irq_enable			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_IRQ_ENABLE
int	aiss6c_query				(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_QUERY
int	aiss6c_reg_mod				(int fd, int index, int verbose, u32 reg, u32 value, u32 mask);	// AISS6C_IOCTL_REG_MOD
int	aiss6c_reg_read				(int fd, int index, int verbose, u32 reg, u32* value);			// AISS6C_IOCTL_REG_READ
int	aiss6c_reg_write			(int fd, int index, int verbose, u32 reg, u32 value);			// AISS6C_IOCTL_REG_WRITE
int	aiss6c_rx_io_abort			(int fd, int index, int verbose, s32* get);						// AISS6C_IOCTL_RX_IO_ABORT
int	aiss6c_rx_io_mode			(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_RX_IO_MODE
int	aiss6c_rx_io_overflow		(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_RX_IO_OVERFLOW
int	aiss6c_rx_io_timeout		(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_RX_IO_TIMEOUT
int	aiss6c_rx_io_underflow		(int fd, int index, int verbose, s32 set, s32* get);			// AISS6C_IOCTL_RX_IO_UNDERFLOW
int	aiss6c_wait_cancel			(int fd, int index, int verbose, gsc_wait_t* wait);				// AISS6C_IOCTL_WAIT_CANCEL
int	aiss6c_wait_event			(int fd, int index, int verbose, gsc_wait_t* wait);				// AISS6C_IOCTL_WAIT_EVENT
int	aiss6c_wait_status			(int fd, int index, int verbose, gsc_wait_t* wait);				// AISS6C_IOCTL_WAIT_STATUS

// Auxiliary utility services

int	aiss6c_config_ai			(int fd, int index, int verbose, s32 fsamp);
int	aiss6c_config_aux			(int fd, int index, int verbose);
int	aiss6c_fsamp_ai_compute		(int fd, int index, int verbose, s32 fsamp, s32* ndiv, s32* warp, double* rate);
int	aiss6c_fsamp_ai_report		(int fd, int index, int verbose, int chan, s32* fsamp);
int	aiss6c_fsamp_ai_report_all	(int fd, int index, int verbose, s32* fsamp);
int	aiss6c_id_device			(int fd, int index, int verbose);

int	aiss6c_count_boards			(int verbose, s32* get);
int	aiss6c_fsamp_ai_get			(int fd, int title, s32* get, s32* warp);
int	aiss6c_reg_list				(int fd, int detail);

const gsc_reg_def_t*			aiss6c_reg_get_def_id		(u32 reg);
const gsc_reg_def_t*			aiss6c_reg_get_def_index	(int index);
const char*						aiss6c_reg_get_desc			(u32 reg);
const char*						aiss6c_reg_get_name			(u32 reg);

// Retained for backwards compatibility only:
int	aiss6c_auto_cal_sts			(int fd, int index, int verbose, s32* get);
int	aiss6c_auto_calibrate		(int fd, int index, int verbose);

#endif
