// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/18AISS6C/driver/18aiss6c.h $
// $Rev: 53515 $
// $Date: 2023-08-03 10:20:05 -0500 (Thu, 03 Aug 2023) $

// 18AISS6C: Device Driver: header file

#ifndef	__18AISS6C_H__
#define	__18AISS6C_H__

#include "gsc_common.h"
#include "gsc_pci9056.h"



// macros *********************************************************************

#define	AISS6C_BASE_NAME					"18aiss6c"
#define	AISS6C_BASE_NAME_LC					AISS6C_BASE_NAME
#define	AISS6C_BASE_NAME_UC					"AISS6C"

// IOCTL command codes
#define	AISS6C_IOCTL_REG_READ				OS_IOCTL_RW( 0, 12, gsc_reg_t)
#define	AISS6C_IOCTL_REG_WRITE				OS_IOCTL_W ( 1, 12, gsc_reg_t)
#define	AISS6C_IOCTL_REG_MOD				OS_IOCTL_W ( 2, 12, gsc_reg_t)
#define	AISS6C_IOCTL_QUERY					OS_IOCTL_RW( 3,  4, s32)
#define	AISS6C_IOCTL_INITIALIZE				OS_IOCTL   ( 4)
#define	AISS6C_IOCTL_AUTOCAL				OS_IOCTL   ( 5)
#define	AISS6C_IOCTL_AUTOCAL_STATUS			OS_IOCTL_R ( 6,  4, s32)
#define	AISS6C_IOCTL_AI_BUF_CLEAR			OS_IOCTL   ( 7)
#define	AISS6C_IOCTL_AI_BUF_LEVEL			OS_IOCTL_R ( 8,  4, s32)
#define	AISS6C_IOCTL_AI_BUF_OVERFLOW		OS_IOCTL_RW( 9,  4, s32)
#define	AISS6C_IOCTL_AI_BUF_UNDERFLOW		OS_IOCTL_RW(10,  4, s32)
#define	AISS6C_IOCTL_AI_BURST_ENABLE		OS_IOCTL_RW(11,  4, s32)
#define	AISS6C_IOCTL_AI_BURST_SIZE			OS_IOCTL_RW(12,  4, s32)
#define	AISS6C_IOCTL_AI_BURST_STATUS		OS_IOCTL_RW(13,  4, s32)
#define	AISS6C_IOCTL_AI_CHAN_SEL			OS_IOCTL_RW(14,  4, s32)
#define	AISS6C_IOCTL_AI_CLK_SRC				OS_IOCTL_RW(15,  4, s32)
#define	AISS6C_IOCTL_AI_CONFIG				OS_IOCTL_RW(16,  4, s32)
#define	AISS6C_IOCTL_AI_ENABLE				OS_IOCTL_RW(17,  4, s32)
#define	AISS6C_IOCTL_AI_FILTER				OS_IOCTL_RW(18,  4, s32)
#define	AISS6C_IOCTL_AI_RANGE				OS_IOCTL_RW(19,  4, s32)
#define	AISS6C_IOCTL_AI_SW_CLOCK			OS_IOCTL   (20)
#define	AISS6C_IOCTL_AI_SW_TRIGGER			OS_IOCTL   (21)
#define	AISS6C_IOCTL_AI_THRESH_LVL			OS_IOCTL_RW(22,  4, s32)
#define	AISS6C_IOCTL_AI_THRESH_STS			OS_IOCTL_RW(23,  4, s32)
#define	AISS6C_IOCTL_AI_TRIG_SRC			OS_IOCTL_RW(24,  4, s32)
#define	AISS6C_IOCTL_AI_WARP_MODE			OS_IOCTL_RW(25,  4, s32)
#define	AISS6C_IOCTL_AUX_CLK_MODE			OS_IOCTL_RW(26,  4, s32)
#define	AISS6C_IOCTL_AUX_IN_POL				OS_IOCTL_RW(27,  4, s32)
#define	AISS6C_IOCTL_AUX_NOISE				OS_IOCTL_RW(28,  4, s32)
#define	AISS6C_IOCTL_AUX_OUT_POL			OS_IOCTL_RW(29,  4, s32)
#define	AISS6C_IOCTL_AUX_SYNC_MODE			OS_IOCTL_RW(30,  4, s32)
#define	AISS6C_IOCTL_DATA_FORMAT			OS_IOCTL_RW(31,  4, s32)
#define	AISS6C_IOCTL_DIO_DIR_OUT			OS_IOCTL_RW(32,  4, s32)
#define	AISS6C_IOCTL_DIO_READ				OS_IOCTL_RW(33,  4, s32)
#define	AISS6C_IOCTL_DIO_WRITE				OS_IOCTL_RW(34,  4, s32)
#define	AISS6C_IOCTL_GEN_A_ENABLE			OS_IOCTL_RW(35,  4, s32)
#define	AISS6C_IOCTL_GEN_A_NDIV				OS_IOCTL_RW(36,  4, s32)
#define	AISS6C_IOCTL_GEN_B_ENABLE			OS_IOCTL_RW(37,  4, s32)
#define	AISS6C_IOCTL_GEN_B_NDIV				OS_IOCTL_RW(38,  4, s32)
#define	AISS6C_IOCTL_IRQ_ENABLE				OS_IOCTL_RW(39,  4, s32)
#define	AISS6C_IOCTL_RX_IO_ABORT			OS_IOCTL_R (40,  4, s32)
#define	AISS6C_IOCTL_RX_IO_MODE				OS_IOCTL_RW(41,  4, s32)
#define	AISS6C_IOCTL_RX_IO_OVERFLOW			OS_IOCTL_RW(42,  4, s32)
#define	AISS6C_IOCTL_RX_IO_TIMEOUT			OS_IOCTL_RW(43,  4, s32)
#define	AISS6C_IOCTL_RX_IO_UNDERFLOW		OS_IOCTL_RW(44,  4, s32)
#define	AISS6C_IOCTL_WAIT_EVENT				OS_IOCTL_RW(45, 28, gsc_wait_t)
#define	AISS6C_IOCTL_WAIT_CANCEL			OS_IOCTL_RW(46, 28, gsc_wait_t)
#define	AISS6C_IOCTL_WAIT_STATUS			OS_IOCTL_RW(47, 28, gsc_wait_t)

//*****************************************************************************
// AISS6C_IOCTL_REG_READ
// AISS6C_IOCTL_REG_WRITE
// AISS6C_IOCTL_REG_MOD
//
#define	AISS6C_REG_ENCODE(s,o)				GSC_REG_ENCODE(GSC_REG_TYPE_BAR2,(s),(o))
// Parameter:	gsc_reg_t*
#define	AISS6C_GSC_BCR						AISS6C_REG_ENCODE(4,0x00)// Board Control Register
#define	AISS6C_GSC_DIOPR					AISS6C_REG_ENCODE(4,0x04)// Digital I/O Port Register

#define	AISS6C_GSC_ASIOR					AISS6C_REG_ENCODE(4,0x10)// Auxiliary Sync I/O Register
#define	AISS6C_GSC_ICR						AISS6C_REG_ENCODE(4,0x14)// Input Configuration Register
#define	AISS6C_GSC_IDBR						AISS6C_REG_ENCODE(4,0x18)// Input Data Buffer Register
#define	AISS6C_GSC_RGAR						AISS6C_REG_ENCODE(4,0x1C)// Rate Generator A Register
#define	AISS6C_GSC_RGBR						AISS6C_REG_ENCODE(4,0x20)// Rate Generator B Register
#define	AISS6C_GSC_IBBSR					AISS6C_REG_ENCODE(4,0x24)// Input Burst Block Size Register
#define	AISS6C_GSC_IBSR						AISS6C_REG_ENCODE(4,0x28)// Input Buffer Size Register
#define	AISS6C_GSC_IBTR						AISS6C_REG_ENCODE(4,0x2C)// Input Buffer Threshold Register
#define	AISS6C_GSC_PSR						AISS6C_REG_ENCODE(4,0x30)// Primary Status Register
#define	AISS6C_GSC_ACR						AISS6C_REG_ENCODE(4,0x34)// Assymbly Configuration Register
#define	AISS6C_GSC_AVR						AISS6C_REG_ENCODE(4,0x38)// Autocal Values Register

//*****************************************************************************
// AISS6C_IOCTL_QUERY
//
//	Parameter:	s32
//		Pass in a value from the list below.
//		The value returned is the answer to the query.

typedef enum
{
	AISS6C_QUERY_AI_FILTER,		// Input Filter Type
	AISS6C_QUERY_AI_RANGE,		// Input Voltage Range
	AISS6C_QUERY_AUTOCAL_MS,	// Max autocalibrate period in ms.
	AISS6C_QUERY_CHANNEL_MAX,	// Maximum number of input channels supported.
	AISS6C_QUERY_CHANNEL_QTY,	// The number of input channels supported.
	AISS6C_QUERY_COUNT,			// How many query options are supported?
	AISS6C_QUERY_DEVICE_TYPE,	// Value from gsc_dev_type_t
	AISS6C_QUERY_FGEN_MAX,		// Rate Generator maximum output rate.
	AISS6C_QUERY_FGEN_MIN,		// Rate Generator minimum output rate.
	AISS6C_QUERY_FIFO_SIZE,		// Rx FIFO depth in 32-bit samples
	AISS6C_QUERY_FSAMP_MAX,		// The maximum sample rate per channel.
	AISS6C_QUERY_FSAMP_MIN,		// The minimum sample rate per channel.
	AISS6C_QUERY_INIT_MS,		// Max initialize period in ms.
	AISS6C_QUERY_MASTER_CLOCK,	// Master clock frequency
	AISS6C_QUERY_NDIV_MAX,		// Maximum rate generator Ndiv value.
	AISS6C_QUERY_NDIV_MIN,		// Maximum rate generator Ndiv value.
	AISS6C_QUERY_RATE_GEN_QTY,	// Number of Rate Generatorts.
	AISS6C_IOCTL_QUERY_LAST
} aiss6c_query_t;

#define	AISS6C_IOCTL_QUERY_ERROR			(-1)

// Retained for backwards compatibility only:
#define	AISS6C_QUERY_AUTO_CAL_MS			AISS6C_QUERY_AUTOCAL_MS

// AISS6C_QUERY_AI_FILTER options
#define	AISS6C_AI_FILTER_F1					0	// 200KHz Chebysheb, 5th order, 0.5db

// AISS6C_QUERY_AI_RANGE options
#define	AISS6C_AI_RANGE_20_10				0	// +-20, +-10
#define	AISS6C_AI_RANGE_10_5				1	// +-10, +-5

//*****************************************************************************
// AISS6C_IOCTL_INITIALIZE					BCR D31
//
//	Parameter:	None

//*****************************************************************************
// AISS6C_IOCTL_AUTOCAL						BCR D20, D21
//
//	Parameter:	None

// Retained for backwards compatibility only:
#define	AISS6C_IOCTL_AUTO_CALIBRATE			AISS6C_IOCTL_AUTOCAL

//*****************************************************************************
// AISS6C_IOCTL_AUTOCAL_STATUS				BCR D20, D21
//
//	Parameter:	s32*
//		One of the below values is returned.
#define	AISS6C_AUTOCAL_STATUS_ACTIVE		0
#define	AISS6C_AUTOCAL_STATUS_FAIL			1
#define	AISS6C_AUTOCAL_STATUS_PASS			2

// Retained for backwards compatibility only:
#define	AISS6C_IOCTL_AUTO_CAL_STS			AISS6C_IOCTL_AUTOCAL_STATUS
#define	AISS6C_AUTO_CAL_STS_ACTIVE			AISS6C_AUTOCAL_STATUS_ACTIVE
#define	AISS6C_AUTO_CAL_STS_FAIL			AISS6C_AUTOCAL_STATUS_FAIL
#define	AISS6C_AUTO_CAL_STS_PASS			AISS6C_AUTOCAL_STATUS_PASS

//*****************************************************************************
// AISS6C_IOCTL_AI_BUF_CLEAR				BCR D13
//
//	Parameter:	None.

//*****************************************************************************
// AISS6C_IOCTL_AI_BUF_LEVEL				IBSR D0-D18
//
//	Parameter:	s32*
//		The value returned is the current buffer fill level.

//*****************************************************************************
// AISS6C_IOCTL_AI_BUF_OVERFLOW				BCR D15
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS6C_BUF_OVERFLOW_CLEAR			0
#define	AISS6C_BUF_OVERFLOW_TEST			(-1)

// For queries the following values are returned.
#define	AISS6C_BUF_OVERFLOW_NO				0
#define	AISS6C_BUF_OVERFLOW_YES				1

//*****************************************************************************
// AISS6C_IOCTL_AI_BUF_UNDERFLOW			BCR D16
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS6C_BUF_UNDERFLOW_CLEAR			0
#define	AISS6C_BUF_UNDERFLOW_TEST			(-1)

// For queries the following values are returned.
#define	AISS6C_BUF_UNDERFLOW_NO				0
#define	AISS6C_BUF_UNDERFLOW_YES			1

//*****************************************************************************
// AISS6C_IOCTL_AI_BURST_ENABLE				BCR D9
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS6C_BURST_ENABLE_NO				0
#define	AISS6C_BURST_ENABLE_YES				1

//*****************************************************************************
// AISS6C_IOCTL_AI_BURST_SIZE				IBBSR D0-D23
//
//	Parameter:	s32*
//		Pass in any value between the below inclusive limits, or
//		-1 to read the current setting.
//		At this time the valid range is 0-0xFFFFFF.

//*****************************************************************************
// AISS6C_IOCTL_AI_BURST_STATUS				BCR D10
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS6C_BURST_STATUS_READY			0
#define	AISS6C_BURST_STATUS_BUSY			1

//*****************************************************************************
// AISS6C_IOCTL_AI_CHAN_SEL					ICR D0-D5 (for 6 channel devices)
//
//	Parameter:	s32*
//		Pass in a bitmap of the channels to enable, or
//		-1 to read the current setting.
//		A valid bitmap is dependent on the number of input channels on the
//		device.

//*****************************************************************************
// AISS6C_IOCTL_AI_CLK_SRC					ICR D8-D9
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS6C_AI_CLK_SRC_RAG				0
#define	AISS6C_AI_CLK_SRC_RBG				1
#define	AISS6C_AI_CLK_SRC_EXT				2

//*****************************************************************************
// AISS6C_IOCTL_AI_CONFIG					ICR D16-D17
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS6C_AI_CONFIG_EXT				0	// External inputs
#define	AISS6C_AI_CONFIG_ZERO				2	// Zero test
#define	AISS6C_AI_CONFIG_VREF				3	// Vref test

//*****************************************************************************
// AISS6C_IOCTL_AI_ENABLE					BCR D12
//
//	Parameter:	s32*
//		Pass in any valid option below, or
//		-1 to read the current setting.
#define	AISS6C_AI_ENABLE_NO					0	// Disable the buffer.
#define	AISS6C_AI_ENABLE_YES				1	// Enable the buffer.

//*****************************************************************************
// AISS6C_IOCTL_AI_FILTER					ICR D24
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS6C_AI_FILTER_DISABLE			0
#define	AISS6C_AI_FILTER_ENABLE				1

//*****************************************************************************
// AISS6C_IOCTL_AI_RANGE					ICR D20
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS6C_RANGE_5V						0	// +- 5 volts
#define	AISS6C_RANGE_10V					1	// +- 10 volts
#define	AISS6C_RANGE_20V					2	// +- 20 volts

//*****************************************************************************
// AISS6C_IOCTL_AI_SW_CLOCK					BCR D8
//
//	Parameter:	None.

//*****************************************************************************
// AISS6C_IOCTL_AI_SW_TRIGGER				BCR D11
//
//	Parameter:	None.

//*****************************************************************************
// AISS6C_IOCTL_AI_THRESH_LVL				IBTR D0-D18
//
//	Parameter:	s32*
//		Pass in any valid value from 0x0 to 0x7FFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS6C_IOCTL_AI_THRESH_STS				IBTR D20, BCR D14
//
//	Parameter:	s32*
//		The value returned is one of the following.
#define	AISS6C_THRESH_STS_CLEAR				0
#define	AISS6C_THRESH_STS_SET				1

//*****************************************************************************
// AISS6C_IOCTL_AI_TRIG_SRC					ICR D12-D13
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS6C_AI_TRIG_SRC_RBG				0
#define	AISS6C_AI_TRIG_SRC_RAG				1
#define	AISS6C_AI_TRIG_SRC_EXT				2

//*****************************************************************************
// AISS6C_IOCTL_AI_WARP_MODE				BCR D22
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS6C_AI_WARP_MODE_DISABLE			0
#define	AISS6C_AI_WARP_MODE_ENABLE			1

//*****************************************************************************
// AISS6C_IOCTL_AUX_CLK_MODE				ASIOR D0-D1
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS6C_AUX_CLK_MODE_DISABLE			0
#define	AISS6C_AUX_CLK_MODE_IN				1
#define	AISS6C_AUX_CLK_MODE_OUT				2

//*****************************************************************************
// AISS6C_IOCTL_AUX_IN_POL					ASIOR D8
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS6C_AUX_IN_POL_L2H				0
#define	AISS6C_AUX_IN_POL_H2L				1

//*****************************************************************************
// AISS6C_IOCTL_AUX_NOISE					ASIOR D10
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS6C_AUX_NOISE_LOW				0
#define	AISS6C_AUX_NOISE_HIGH				1

//*****************************************************************************
// AISS6C_IOCTL_AUX_OUT_POL					ASIOR D9
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS6C_AUX_OUT_POL_L2H				0
#define	AISS6C_AUX_OUT_POL_H2L				1

//*****************************************************************************
// AISS6C_IOCTL_AUX_SYNC_MODE				ASIOR D2-D3
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS6C_AUX_SYNC_MODE_DISABLE		0
#define	AISS6C_AUX_SYNC_MODE_IN				1
#define	AISS6C_AUX_SYNC_MODE_OUT			2

//*****************************************************************************
// AISS6C_IOCTL_DATA_FORMAT					BCR D17
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS6C_DATA_FORMAT_2S_COMP			0	// Twos Compliment
#define	AISS6C_DATA_FORMAT_OFF_BIN			1	// Offset Binary

//*****************************************************************************
// AISS6C_IOCTL_DIO_DIR_OUT					DIOPR D7, D15
//
//	Parameter:	s32*
//		Pass in any value between the range of 0 to 0x3F, or
//		-1 to read the current setting.
#define	AISS6C_DIO_DIR_OUT_NONE				0
#define	AISS6C_DIO_DIR_OUT_D0_D3			1
#define	AISS6C_DIO_DIR_OUT_D4_D7			2
#define	AISS6C_DIO_DIR_OUT_D0_D7			3

//*****************************************************************************
// AISS6C_IOCTL_DIO_READ					DIOPR D0-D3, D8-D11
//
//	Parameter:	s32*
//		The value returned is in the range of 0 to 0xFF.

//*****************************************************************************
// AISS6C_IOCTL_DIO_WRITE					DIOPR D0-D3, D8-D11
//
//	Parameter:	s32*
//		Pass in any value in the range of 0 to 0xFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS6C_IOCTL_GEN_A_ENABLE				BCR D18
// AISS6C_IOCTL_GEN_B_ENABLE				BCR D19
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS6C_GEN_ENABLE_NO				0
#define	AISS6C_GEN_ENABLE_YES				1

//*****************************************************************************
// AISS6C_IOCTL_GEN_A_NDIV					RGAR D0-D23
// AISS6C_IOCTL_GEN_B_NDIV					RGBR D0-D23
//
//	Parameter:	s32*
//		Pass in any value in the range of 81 to 0xFFFFFF, or
//		-1 to read the current setting.

//*****************************************************************************
// AISS6C_IOCTL_IRQ_ENABLE
//
//	Parameter:	s32*
//		Pass in any combination of the below options, or
//		-1 to read the current setting.
#define	AISS6C_IRQ_AUTOCAL_DONE				0x0001
#define	AISS6C_IRQ_AI_THRESH_H2L			0x0002
#define	AISS6C_IRQ_AI_THRESH_L2H			0x0004
#define	AISS6C_IRQ_AI_FAULT					0x0008
#define	AISS6C_IRQ_AI_BURST_START			0x0010
#define	AISS6C_IRQ_AI_BURST_DONE			0x0020
#define	AISS6C_IRQ_AI_CLOCK					0x0040
#define	AISS6C_IRQ_DIO_0_L2H				0x0080
#define	AISS6C_IRQ_ALL						0x00FF

// Retained for backwards compatibility only:
#define	AISS6C_IRQ_AUTO_CAL_DONE			AISS6C_IRQ_AUTOCAL_DONE

//*****************************************************************************
// AISS6C_IOCTL_RX_IO_ABORT
//
//	Parameter:	s32*
//		The returned value is one of the below options.
#define	AISS6C_IO_ABORT_NO					0
#define	AISS6C_IO_ABORT_YES					1

//*****************************************************************************
// AISS6C_IOCTL_RX_IO_MODE
//
//	Parameter:	s32*
//		Pass in any of the gsc_io_mode_t options, or
//		-1 to read the current setting.
#define	AISS6C_IO_MODE_DEFAULT				GSC_IO_MODE_PIO
// GSC_IO_MODE_PIO
// GSC_IO_MODE_BMDMA
// GSC_IO_MODE_DMDMA

//*****************************************************************************
// AISS6C_IOCTL_RX_IO_OVERFLOW
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS6C_IO_OVERFLOW_DEFAULT			AISS6C_IO_OVERFLOW_CHECK
#define	AISS6C_IO_OVERFLOW_IGNORE			0
#define	AISS6C_IO_OVERFLOW_CHECK			1

//*****************************************************************************
// AISS6C_IOCTL_RX_IO_TIMEOUT (in seconds)
//
//	Parameter:	s32*
//		Pass in any value from the minimim to the maximim, the infinite option,
//		or -1 to read the current setting. The value -1 is returned if the
//		feature is not supported, but this should never happen.
#define	AISS6C_IO_TIMEOUT_DEFAULT			10
#define	AISS6C_IO_TIMEOUT_NO_SLEEP			0
#define	AISS6C_IO_TIMEOUT_MIN				0
#define	AISS6C_IO_TIMEOUT_MAX				GSC_IO_TIMEOUT_MAX
#define	AISS6C_IO_TIMEOUT_INFINITE			GSC_IO_TIMEOUT_INFINITE

//*****************************************************************************
// AISS6C_IOCTL_RX_IO_UNDERFLOW
//
//	Parameter:	s32*
//		Pass in any of the below options, or
//		-1 to read the current setting.
#define	AISS6C_IO_UNDERFLOW_DEFAULT			AISS6C_IO_UNDERFLOW_CHECK
#define	AISS6C_IO_UNDERFLOW_IGNORE			0
#define	AISS6C_IO_UNDERFLOW_CHECK			1

//*****************************************************************************
// AISS6C_IOCTL_WAIT_EVENT					all fields must be valid
// AISS6C_IOCTL_WAIT_CANCEL					fields need not be valid
// AISS6C_IOCTL_WAIT_STATUS					fields need not be valid
//
//	Parameter:	gsc_wait_t*
// gsc_wait_t.flags - see gsc_common.h
// gsc_wait_t.main - see gsc_common.h
// gsc_wait_t.gsc
#define	AISS6C_WAIT_GSC_AUTOCAL_DONE		AISS6C_IRQ_AUTOCAL_DONE
#define	AISS6C_WAIT_GSC_AI_THRESH_H2L		AISS6C_IRQ_AI_THRESH_H2L
#define	AISS6C_WAIT_GSC_AI_THRESH_L2H		AISS6C_IRQ_AI_THRESH_L2H
#define	AISS6C_WAIT_GSC_AI_FAULT			AISS6C_IRQ_AI_FAULT
#define	AISS6C_WAIT_GSC_AI_BURST_START		AISS6C_IRQ_AI_BURST_START
#define	AISS6C_WAIT_GSC_AI_BURST_DONE		AISS6C_IRQ_AI_BURST_DONE
#define	AISS6C_WAIT_GSC_AI_CLOCK			AISS6C_IRQ_AI_CLOCK
#define	AISS6C_WAIT_GSC_DIO_0_L2H			AISS6C_IRQ_DIO_0_L2H
#define	AISS6C_WAIT_GSC_ALL					AISS6C_IRQ_ALL
// gsc_wait_t.alt flags
#define	AISS6C_WAIT_ALT_ALL					0x0000
// gsc_wait_t.io
#define	AISS6C_WAIT_IO_RX_ABORT				0x0001
#define	AISS6C_WAIT_IO_RX_DONE				0x0002
#define	AISS6C_WAIT_IO_RX_ERROR				0x0004
#define	AISS6C_WAIT_IO_RX_TIMEOUT			0x0008

#define	AISS6C_WAIT_IO_ALL					0x000F

// Retained for backwards compatibility only:
#define	AISS6C_WAIT_GSC_AUTO_CAL_DONE		AISS6C_WAIT_GSC_AUTOCAL_DONE



#endif
