// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/utils/reg_mod.c $
// $Rev: 56222 $
// $Date: 2025-02-06 13:45:16 -0600 (Thu, 06 Feb 2025) $

// 16AO16: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ao16_reg_mod
*
*	Purpose:
*
*		Provide a visual wrapper for the AO16_IOCTL_REG_MOD service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		reg		This is the register to access.
*
*		set		This is the value to apply via the mask.
*
*		mask	These are the bits to modify.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ao16_reg_mod(int fd, int index, int verbose, u32 reg, u32 set, u32 mask)
{
	gsc_reg_t	arg;
	int			errs;
	const char*	name;
	int			ret;

	if (verbose)
		gsc_label_index("Register Mod", index);

	arg.reg		= reg;
	arg.value	= set;
	arg.mask	= mask;
	ret			= ao16_ioctl(fd, AO16_IOCTL_REG_MOD, &arg);
	errs		= ret ? 1 : 0;

	if (verbose)
	{
		name	= ao16_reg_get_name(reg);
		printf(	"%s  (val 0x%08lX, mask 0x%08lX, %s)\n",
				errs ? "FAIL <---" : "PASS",
				(unsigned long) set,
				(unsigned long) mask,
				name ? name : "UNKNOWN");
	}

	return(errs);
}


