// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/utils/range.c $
// $Rev: 56222 $
// $Date: 2025-02-06 13:45:16 -0600 (Thu, 06 Feb 2025) $

// 16AO16: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ao16_range
*
*	Purpose:
*
*		Provide a visual wrapper for the AO16_IOCTL_RANGE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		set		This is the value to apply.
*
*		get		The results are reported here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	ao16_range(int fd, int index, int verbose, s32 set, s32* get)
{
	char	buf[128];
	int		errs;
	int		ret;

	if (verbose)
		gsc_label_index("Analog Output Range", index);

	ret		= ao16_ioctl(fd, AO16_IOCTL_RANGE, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "INVALID: %ld", (long) set);
			break;

		case AO16_RANGE_1_25:

			strcpy(buf, "+-1.25v");
			break;

		case AO16_RANGE_2_5:

			strcpy(buf, "+-2.5v");
			break;

		case AO16_RANGE_5:

			strcpy(buf, "+-5v");
			break;

		case AO16_RANGE_10:

			strcpy(buf, "+-10v");
			break;

		case AO16_RANGE_20:

			strcpy(buf, "+-20v");
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", buf);

	if (get)
		get[0]	= set;

	return(errs);
}


