// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/utils/output_filter.c $
// $Rev: 56222 $
// $Date: 2025-02-06 13:45:16 -0600 (Thu, 06 Feb 2025) $

// 16AO16: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ao16_output_filter
*
*	Purpose:
*
*		Provide a visual wrapper for the AO16_IOCTL_OUTPUT_FILTER service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		set		This is the value to apply.
*
*		get		The results are reported here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	ao16_output_filter(int fd, int index, int verbose, s32 set, s32* get)
{
	char	buf[128];
	int		errs;
	int		ret;

	if (verbose)
		gsc_label_index("Output Filter", index);

	ret		= ao16_ioctl(fd, AO16_IOCTL_OUTPUT_FILTER, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "INVALID: %ld", (long) set);
			break;

		case -1:

			strcpy(buf, "Not Supported");
			break;

		case AO16_OUTPUT_FILTER_NONE:

			strcpy(buf, "None");
			break;

		case AO16_OUTPUT_FILTER_A:

			strcpy(buf, "A");
			break;

		case AO16_OUTPUT_FILTER_B:

			strcpy(buf, "B");
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", buf);

	if (get)
		get[0]	= set;

	return(errs);
}


