// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/utils/id.c $
// $Rev: 56222 $
// $Date: 2025-02-06 13:45:16 -0600 (Thu, 06 Feb 2025) $

// 16AO16: Utilities: source file

#include "main.h"



//*****************************************************************************
static int _id_device_pci(int fd)
{
	int	errs;
	u32	reg;

	// Vendor ID ====================================================
	gsc_label("Vendor ID");
	errs	= ao16_reg_read(fd, -1, 0, GSC_PCI_9056_VIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	// Device ID ====================================================
	gsc_label("Device ID");
	errs	+= ao16_reg_read(fd, -1, 0, GSC_PCI_9056_DIDR, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x9056)
	{
		printf("(PCI9056)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	// Subsystem Vendor ID ==========================================
	gsc_label("Sub Vendor ID");
	errs	+= ao16_reg_read(fd, -1, 0, GSC_PCI_9056_SVID, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x10B5)
	{
		printf("(PLX)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	// Subsystem ID =================================================
	gsc_label("Subsystem ID");
	errs	+= ao16_reg_read(fd, -1, 0, GSC_PCI_9056_SID, &reg);
	printf("0x%04lX      ", (long) reg);

	if (reg == 0x3120)
	{
		printf("(16AO16, 16AO16FLV)\n");
	}
	else
	{
		errs++;
		printf("(UNKNOWN) FAIL <---\n");
	}

	return(errs);
}



//*****************************************************************************
int ao16_id_device(int fd, int index, int verbose)
{
	s32			device_type;
	int			errs		= 0;
	s32			model;
	const char*	psz			= "";

	if (verbose)
		gsc_label_index("Device", index);

	errs	+= ao16_query(fd, -1, 0, AO16_QUERY_DEVICE_TYPE, &device_type);
	errs	+= ao16_query(fd, -1, 0, AO16_QUERY_MODEL, &model);

	if (errs == 0)
	{
		switch (device_type)
		{
			default:

				if (verbose)
				{
					printf(	"FAIL <---  (unexpected device type: %ld)",
							(long) device_type);
				}

				errs++;
				break;

			case GSC_DEV_TYPE_16AO16:

				switch (model)
				{
					default:

						if (verbose)
						{
							printf(	"FAIL <---  (unexpected device type: %ld)",
									(long) device_type);
						}

						errs++;
						break;

					case AO16_MODEL_16AO16:

						psz	= "16AO16";
						break;

					case AO16_MODEL_16AO16FLV:

						psz	= "16AO16FLV";
						break;
				}

				break;
		}
	}

	if (verbose)
	{
		printf("%s\n", psz);
		gsc_label_level_inc();
	}

	errs	+= _id_device_pci(fd);

	if (verbose)
		gsc_label_level_dec();

	return(errs);
}


