// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/utils/burst_enable.c $
// $Rev: 56222 $
// $Date: 2025-02-06 13:45:16 -0600 (Thu, 06 Feb 2025) $

// 16AO16: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ao16_burst_enable
*
*	Purpose:
*
*		Provide a visual wrapper for the AO16_IOCTL_BURST_ENABLE service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		set		This is the value to apply.
*
*		get		The results are reported here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	ao16_burst_enable(int fd, int index, int verbose, s32 set, s32* get)
{
	char	buf[128];
	int		errs;
	int		ret;

	if (verbose)
		gsc_label_index("Burst Enable", index);

	ret		= ao16_ioctl(fd, AO16_IOCTL_BURST_ENABLE, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "INVALID: %ld", (long) set);
			break;

		case AO16_BURST_ENABLE_NO:

			strcpy(buf, "No/Disabled");
			break;

		case AO16_BURST_ENABLE_YES:

			strcpy(buf, "Yes/Enabled");
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", buf);

	if (get)
		get[0]	= set;

	return(errs);
}


