// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/utils/buffer_status.c $
// $Rev: 56222 $
// $Date: 2025-02-06 13:45:16 -0600 (Thu, 06 Feb 2025) $

// 16AO16: Utilities: source file

#include "main.h"



/******************************************************************************
*
*	Function:	ao16_buffer_status
*
*	Purpose:
*
*		Provide a visual wrapper for the AO16_IOCTL_BUFFER_STATUS service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		get		The results are reported here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int ao16_buffer_status(int fd, int index, int verbose, s32* get)
{
	char	buf[128];
	int		errs;
	int		ret;
	s32		set		= -1;

	if (verbose)
		gsc_label_index("Buffer Status", index);

	ret		= ao16_ioctl(fd, AO16_IOCTL_BUFFER_STATUS, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "INVALID: %ld", (long) get[0]);
			break;

		case AO16_BUFFER_STATUS_EMPTY:

			strcpy(buf, "Empty");
			break;

		case AO16_BUFFER_STATUS_1Q_FULL:

			strcpy(buf, "< 1/4 Full");
			break;

		case AO16_BUFFER_STATUS_MEDIUM:

			strcpy(buf, "Medium");
			break;

		case AO16_BUFFER_STATUS_3Q_FULL:

			strcpy(buf, ">= 3/4 Full");
			break;

		case AO16_BUFFER_STATUS_FULL:

			strcpy(buf, "Full");
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", buf);

	if (get)
		get[0]	= set;

	return(errs);
}


