// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/utils/auto_cal_sts.c $
// $Rev: 56222 $
// $Date: 2025-02-06 13:45:16 -0600 (Thu, 06 Feb 2025) $

// 16AO16: Utilities: source file

#include "main.h"



// This source is retained for backwards compatibility only.

/******************************************************************************
*
*	Function:	ao16_auto_cal_sts
*
*	Purpose:
*
*		Provide a visual wrapper for the AO16_IOCTL_AUTO_CAL_STS service.
*
*	Arguments:
*
*		fd		Use this handle to access the device.
*
*		index	The index of the device to access. Ignore if < 0.
*
*		verbose	Work verbosely? 0 = no, !0 = yes
*
*		get		The results are reported here, if not NULL.
*
*	Returned:
*
*		>= 0	The number of errors encounterred.
*
******************************************************************************/

int	ao16_auto_cal_sts(int fd, int index, int verbose, s32* get)
{
	char		buf[128];
	int			errs;
	const char*	ptr		= buf;
	int			ret;
	s32			set;

	if (verbose)
		gsc_label_index("Autocal Status", index);

	ret		= ao16_ioctl(fd, AO16_IOCTL_AUTO_CAL_STS, &set);
	errs	= ret ? 1 : 0;

	switch (set)
	{
		default:

			errs++;
			sprintf(buf, "Unrecognized option: 0x%lX", (long) set);
			break;

		case AO16_AUTO_CAL_STS_ACTIVE:

			ptr	= "Active";
			break;

		case AO16_AUTO_CAL_STS_FAIL:

			ptr	= "Failed";
			break;

		case AO16_AUTO_CAL_STS_PASS:

			ptr	= "Passed";
			break;
	}

	if (verbose)
		printf("%s  (%s)\n", errs ? "FAIL <---" : "PASS", ptr);

	if (get)
		get[0]	= set;

	return(errs);
}


