// $URL: http://subversion:8080/svn/gsc/trunk/drivers/LINUX/16AO16/16AO16_Linux_2.x.x.x_DN/samples/txrate/perform.c $
// $Rev: 53291 $
// $Date: 2023-06-28 14:20:13 -0500 (Wed, 28 Jun 2023) $

// 16AO16: Sample Application: source file

#include "main.h"



// macros *********************************************************************

#define	_1M	(1024L * 1024L)



// variables ******************************************************************

static u32	_data[_1M];



//*****************************************************************************
static int _io_mode_select(const args_t* args)
{
	s32	dmdma	= 0;
	int	errs	= 0;

	errs	+= ao16_query(args->fd, -1, 1, AO16_QUERY_DMDMA, &dmdma);

	if ((args->io_mode == GSC_IO_MODE_DMDMA) && (dmdma == 0))
	{
		gsc_label_suffix(NULL, NULL);
		printf("Reverting to BMDMA since DMDMA is not supported.\n");
		errs	+= ao16_tx_io_mode(args->fd, -1, 1, GSC_IO_MODE_BMDMA, NULL);
	}
	else
	{
		errs	+= ao16_tx_io_mode(args->fd, -1, 1, args->io_mode, NULL);
	}

	return(errs);

}



//*****************************************************************************
static int _rate_test(const args_t* args, long send)
{
	os_time_ns_t	begin;
	os_time_ns_t	end;
	int				errs		= 0;
	long long		data_limit	= args->tx_mb * 1000000;
	long long		data_total	= 0;
	s32				fifo;
	long long		ms;
	long long		ms_limit	= 1000 * args->seconds;
	long long		ms_total	= 0;
	double			rate;
	long			sent;
	s32				timeout;
	long long		total;

	for (;;)	// A convenience loop.
	{
		memset(_data, 0x01, sizeof(_data));

		// Prefill the output buffer
		gsc_label("Prefill Buffer");
		errs	+= ao16_tx_io_timeout(args->fd, -1, 0, -1, &timeout);
		errs	+= ao16_tx_io_timeout(args->fd, -1, 0, 0, NULL);
		errs	+= ao16_query(args->fd, -1, 0, AO16_QUERY_FIFO_SIZE, &fifo);
		fifo	*= 4;
		send	= sizeof(_data);
		total	= 0;

		for (;;)
		{
			sent	= ao16_write(args->fd, _data, send);

			if (sent < 0)
				errs++;

			if (errs)
				break;

			if (sent < (send / 10))
				break;

			total	+= sent;

			if (total >= (fifo * 2))	// make extra large, fsamp may be very high
				break;
		}

		errs	+= ao16_tx_io_timeout(args->fd, -1, 0, timeout, NULL);
		printf("%s\n", errs ? "FAIL <---" : "PASS");

		if (errs)
			break;

		// Write the data to the device.
		gsc_label("Writing Data");
		os_time_get_ns(&begin);

		for (;;)
		{
			sent	= ao16_write(args->fd, _data, send);

			if (sent < 0)
			{
				errs++;
				printf("FAIL <--- (ao16_write, errno %d)\n", errno);
				break;
			}

			os_time_get_ns(&end);
			data_total	+= sent;
			ms_total	= ((long long) end.tv_sec * 1000 + end.tv_nsec / 1000000)
						- ((long long) begin.tv_sec * 1000 + begin.tv_nsec / 1000000);

			if ((ms_total >= ms_limit) && (data_total >= data_limit))
				break;
		}

		printf(	"%s  (", errs ? "FAIL <---" : "PASS");

		// Volume of data
		total	= data_total;
		gsc_label_long_comma(total / 4);
		printf(" Samples, ");

		// Period
		ms	= ms_total;
		gsc_label_float_comma((double) ms / 1000, -1, 3);
		printf(" Seconds, ");

		// Rate
		ms		= (ms <= 0) ? 1 : ms;
		rate	= ((double) total * 1000000 / 4) / ms / 1000;
		gsc_label_float_comma(rate, -1, 3);
		printf(" S/S)\n");
		break;
	}

	return(errs);
}



//*****************************************************************************
int perform_tests(const args_t* args)
{
	int		errs	= 0;
	s32		fsamp	= 0;
	long	send	= sizeof(_data);

	errs	+= ao16_query			(args->fd, -1, 1, AO16_QUERY_FSAMP_MAX, &fsamp);
	errs	+= ao16_config_ao		(args->fd, -1, 1, fsamp);
	errs	+= _io_mode_select		(args);
	errs	+= ao16_fsamp_report_all(args->fd, -1, 1, NULL);

	gsc_label ("Write Rate");
	printf("(%d second minimum, %ld MB minimum)\n", (int) args->seconds, (long) args->tx_mb);
	gsc_label_level_inc();

	errs	+= _rate_test(args, send);

	gsc_label_level_dec();
	return(errs);
}



